/*
 * Decompiled with CFR 0.152.
 */
package com.chavaillaz.client.jira.apache;

import com.chavaillaz.client.common.security.Authentication;
import com.chavaillaz.client.jira.apache.AbstractApacheHttpClient;
import com.chavaillaz.client.jira.api.SearchApi;
import com.chavaillaz.client.jira.api.expand.IssueExpand;
import com.chavaillaz.client.jira.domain.Filter;
import com.chavaillaz.client.jira.domain.Filters;
import com.chavaillaz.client.jira.domain.Issue;
import com.chavaillaz.client.jira.domain.Query;
import com.fasterxml.jackson.databind.JavaType;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.hc.client5.http.async.methods.SimpleRequestBuilder;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.core5.http.ContentType;

public class ApacheHttpSearchApi<T extends List<? extends Issue>>
extends AbstractApacheHttpClient
implements SearchApi<T> {
    protected final JavaType issuesListType;

    public ApacheHttpSearchApi(CloseableHttpAsyncClient client, String baseUrl, Authentication authentication, JavaType issuesListType) {
        super(client, baseUrl, authentication);
        this.issuesListType = issuesListType;
    }

    @Override
    public CompletableFuture<T> searchIssues(String jql, Integer startAt, Integer maxResults, Set<IssueExpand> expand, Set<String> fields) {
        return this.sendAsync(this.requestBuilder(SimpleRequestBuilder.post(), "search", new Object[0]).setBody(this.serialize(Query.from(jql, startAt, maxResults, expand, fields)), ContentType.APPLICATION_JSON), this.issuesListType);
    }

    @Override
    public CompletableFuture<Filter> addFilter(Filter filter) {
        return this.sendAsync(this.requestBuilder(SimpleRequestBuilder.post(), "filter", new Object[0]).setBody(this.serialize(filter), ContentType.APPLICATION_JSON), Filter.class);
    }

    @Override
    public CompletableFuture<Filter> getFilter(String id) {
        return this.sendAsync(this.requestBuilder(SimpleRequestBuilder.get(), "filter/{0}", new Object[]{id}), Filter.class);
    }

    @Override
    public CompletableFuture<Filters> getFavoriteFilters() {
        return this.sendAsync(this.requestBuilder(SimpleRequestBuilder.get(), "filter/favourite", new Object[0]), Filters.class);
    }

    @Override
    public CompletableFuture<Filter> updateFilter(String id, Filter filter) {
        return this.sendAsync(this.requestBuilder(SimpleRequestBuilder.put(), "filter/{0}", new Object[]{id}).setBody(this.serialize(filter), ContentType.APPLICATION_JSON), Filter.class);
    }

    @Override
    public CompletableFuture<Void> deleteFilter(String id) {
        return this.sendAsync(this.requestBuilder(SimpleRequestBuilder.delete(), "filter/{0}", new Object[]{id}), Void.class);
    }
}

