/*
 * Decompiled with CFR 0.152.
 */
package com.chavaillaz.client.jira.apache;

import com.chavaillaz.client.common.security.Authentication;
import com.chavaillaz.client.jira.apache.AbstractApacheHttpClient;
import com.chavaillaz.client.jira.api.UserApi;
import com.chavaillaz.client.jira.domain.User;
import com.chavaillaz.client.jira.domain.Users;
import java.util.concurrent.CompletableFuture;
import org.apache.hc.client5.http.async.methods.SimpleRequestBuilder;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;

public class ApacheHttpUserApi
extends AbstractApacheHttpClient
implements UserApi {
    public ApacheHttpUserApi(CloseableHttpAsyncClient client, String baseUrl, Authentication authentication) {
        super(client, baseUrl, authentication);
    }

    @Override
    public CompletableFuture<Users> getUsers(String search, Integer startAt, Integer maxResults, Boolean includeInactive) {
        return this.sendAsync(this.requestBuilder(SimpleRequestBuilder.get(), "user/search?username={0}&startAt={1}&maxResults={2}&includeInactive={3}", new Object[]{search, startAt, maxResults, includeInactive}), Users.class);
    }

    @Override
    public CompletableFuture<Users> getAssignableUsers(String search, String key, Integer startAt, Integer maxResults, Boolean includeInactive) {
        String url = key.contains("-") ? "user/assignable/search?username={0}&issueKey={1}&startAt={2}&maxResults={3}&includeInactive={4}" : "user/assignable/search?username={0}&project={1}&startAt={2}&maxResults={3}&includeInactive={4}";
        return this.sendAsync(this.requestBuilder(SimpleRequestBuilder.get(), url, new Object[]{search, key, startAt, maxResults, includeInactive}), Users.class);
    }

    @Override
    public CompletableFuture<User> getUser(String username) {
        return this.sendAsync(this.requestBuilder(SimpleRequestBuilder.get(), "user?username={0}", new Object[]{username}), User.class);
    }

    @Override
    public CompletableFuture<User> getCurrentUser() {
        return this.sendAsync(this.requestBuilder(SimpleRequestBuilder.get(), "myself", new Object[0]), User.class);
    }
}

