/*
 * Decompiled with CFR 0.152.
 */
package com.chavaillaz.client.jira.api;

import com.chavaillaz.client.jira.api.expand.CommentExpand;
import com.chavaillaz.client.jira.api.expand.IssueExpand;
import com.chavaillaz.client.jira.domain.Attachment;
import com.chavaillaz.client.jira.domain.Attachments;
import com.chavaillaz.client.jira.domain.Comment;
import com.chavaillaz.client.jira.domain.Comments;
import com.chavaillaz.client.jira.domain.Identity;
import com.chavaillaz.client.jira.domain.Issue;
import com.chavaillaz.client.jira.domain.IssueTransition;
import com.chavaillaz.client.jira.domain.Link;
import com.chavaillaz.client.jira.domain.RemoteLink;
import com.chavaillaz.client.jira.domain.RemoteLinks;
import com.chavaillaz.client.jira.domain.Transitions;
import com.chavaillaz.client.jira.domain.User;
import com.chavaillaz.client.jira.domain.Votes;
import com.chavaillaz.client.jira.domain.Watchers;
import com.chavaillaz.client.jira.domain.WorkLog;
import com.chavaillaz.client.jira.domain.WorkLogs;
import java.io.File;
import java.io.InputStream;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public interface IssueApi<T extends Issue>
extends AutoCloseable {
    public static final String URL_ISSUE_CREATION = "issue/";
    public static final String URL_ISSUE_ACTION = "issue/{0}";
    public static final String URL_ISSUE_SELECTION = "issue/{0}?expand={1}&fields={2}";
    public static final String URL_ISSUE_ASSIGNEE = "issue/{0}/assignee";
    public static final String URL_ISSUE_TRANSITIONS = "issue/{0}/transitions";
    public static final String URL_ISSUE_COMMENTS_SELECTION = "issue/{0}/comment?startAt={1}&maxResults={2}&expand={3}";
    public static final String URL_ISSUE_COMMENT_CREATION = "issue/{0}/comment";
    public static final String URL_ISSUE_COMMENT_ACTION = "issue/{0}/comment/{1}";
    public static final String URL_ISSUE_COMMENT_SELECTION = "issue/{0}/comment/{1}?expand={2}";
    public static final String URL_ISSUE_VOTES = "issue/{0}/votes";
    public static final String URL_ISSUE_WATCHERS = "issue/{0}/watchers";
    public static final String URL_ISSUE_WATCHER = "issue/{0}/watchers?username={1}";
    public static final String URL_ISSUE_WORK_LOGS = "issue/{0}/worklog";
    public static final String URL_ISSUE_WORK_LOG = "issue/{0}/worklog/{1}";
    public static final String URL_ISSUE_REMOTE_LINKS = "issue/{0}/remotelink";
    public static final String URL_ISSUE_REMOTE_LINK = "issue/{0}/remotelink/{1}";
    public static final String URL_ISSUE_ATTACHMENTS = "issue/{0}/attachments";
    public static final String URL_ATTACHMENT = "attachment/{0}";
    public static final String URL_ISSUE_LINKS = "issueLink/";
    public static final String URL_ISSUE_LINK = "issueLink/{0}";
    public static final Set<String> ALL_FIELDS = Set.of("*all");

    public CompletableFuture<Identity> addIssue(T var1);

    default public CompletableFuture<T> getIssue(String issueKey) {
        return this.getIssue(issueKey, Set.of(IssueExpand.CHANGELOG, IssueExpand.TRANSITIONS));
    }

    default public CompletableFuture<T> getIssue(String issueKey, Set<IssueExpand> expandFlags) {
        return this.getIssue(issueKey, expandFlags, ALL_FIELDS);
    }

    public CompletableFuture<T> getIssue(String var1, Set<IssueExpand> var2, Set<String> var3);

    default public CompletableFuture<Optional<T>> getIssueOptional(String issueKey) {
        return ((CompletableFuture)this.getIssue(issueKey).thenApply(Optional::of)).exceptionally(exception -> Optional.empty());
    }

    default public CompletableFuture<Optional<T>> getIssueOptional(String issueKey, Set<IssueExpand> expandFlags) {
        return ((CompletableFuture)this.getIssue(issueKey, expandFlags).thenApply(Optional::of)).exceptionally(exception -> Optional.empty());
    }

    default public CompletableFuture<Optional<T>> getIssueOptional(String issueKey, Set<IssueExpand> expandFlags, Set<String> fields) {
        return ((CompletableFuture)this.getIssue(issueKey, expandFlags, fields).thenApply(Optional::of)).exceptionally(exception -> Optional.empty());
    }

    public CompletableFuture<Void> updateIssue(T var1);

    public CompletableFuture<Void> deleteIssue(String var1);

    public CompletableFuture<Void> assignIssue(String var1, User var2);

    default public CompletableFuture<Void> unassignIssue(String issueKey) {
        return this.assignIssue(issueKey, null);
    }

    public CompletableFuture<Transitions> getTransitions(String var1);

    public CompletableFuture<Void> doTransition(String var1, IssueTransition<?> var2);

    default public CompletableFuture<Comments> getComments(String issueKey) {
        return this.getComments(issueKey, 0, 50);
    }

    default public CompletableFuture<Comments> getComments(String issueKey, Integer startAt, Integer maxResults) {
        return this.getComments(issueKey, startAt, maxResults, Collections.emptySet());
    }

    public CompletableFuture<Comments> getComments(String var1, Integer var2, Integer var3, Set<CommentExpand> var4);

    default public CompletableFuture<Comment> getComment(String issueKey, String id) {
        return this.getComment(issueKey, id, Collections.emptySet());
    }

    public CompletableFuture<Comment> getComment(String var1, String var2, Set<CommentExpand> var3);

    default public CompletableFuture<Optional<Comment>> getCommentOptional(String issueKey, String id) {
        return ((CompletableFuture)this.getComment(issueKey, id).thenApply(Optional::of)).exceptionally(exception -> Optional.empty());
    }

    default public CompletableFuture<Optional<Comment>> getCommentOptional(String issueKey, String id, Set<CommentExpand> expandFlags) {
        return ((CompletableFuture)this.getComment(issueKey, id, expandFlags).thenApply(Optional::of)).exceptionally(exception -> Optional.empty());
    }

    public CompletableFuture<Comment> addComment(String var1, Comment var2);

    public CompletableFuture<Comment> updateComment(String var1, Comment var2);

    public CompletableFuture<Void> deleteComment(String var1, String var2);

    public CompletableFuture<Void> addVote(String var1);

    public CompletableFuture<Votes> getVotes(String var1);

    public CompletableFuture<Watchers> getWatchers(String var1);

    public CompletableFuture<Void> addWatcher(String var1, String var2);

    public CompletableFuture<Void> deleteWatcher(String var1, String var2);

    public CompletableFuture<WorkLog> addWorkLog(String var1, WorkLog var2);

    public CompletableFuture<WorkLogs> getWorkLogs(String var1);

    public CompletableFuture<WorkLog> getWorkLog(String var1, String var2);

    default public CompletableFuture<Optional<WorkLog>> getWorkLogOptional(String issueKey, String id) {
        return ((CompletableFuture)this.getWorkLog(issueKey, id).thenApply(Optional::of)).exceptionally(exception -> Optional.empty());
    }

    public CompletableFuture<WorkLog> updateWorkLog(String var1, WorkLog var2);

    public CompletableFuture<Void> deleteWorkLog(String var1, String var2);

    public CompletableFuture<Attachment> getAttachment(String var1);

    default public CompletableFuture<Optional<Attachment>> getAttachmentOptional(String id) {
        return ((CompletableFuture)this.getAttachment(id).thenApply(Optional::of)).exceptionally(exception -> Optional.empty());
    }

    public CompletableFuture<InputStream> getAttachmentContent(String var1);

    public CompletableFuture<Attachments> addAttachment(String var1, File ... var2);

    public CompletableFuture<Void> deleteAttachment(String var1);

    public CompletableFuture<RemoteLinks> getRemoteLinks(String var1);

    public CompletableFuture<RemoteLink> getRemoteLink(String var1, String var2);

    default public CompletableFuture<Optional<RemoteLink>> getRemoteLinkOptional(String issueKey, String id) {
        return ((CompletableFuture)this.getRemoteLink(issueKey, id).thenApply(Optional::of)).exceptionally(exception -> Optional.empty());
    }

    public CompletableFuture<Identity> addRemoteLink(String var1, RemoteLink var2);

    public CompletableFuture<Void> updateRemoteLink(String var1, RemoteLink var2);

    public CompletableFuture<Void> deleteRemoteLink(String var1, String var2);

    public CompletableFuture<Link> getIssueLink(String var1);

    default public CompletableFuture<Optional<Link>> getIssueLinkOptional(String id) {
        return ((CompletableFuture)this.getIssueLink(id).thenApply(Optional::of)).exceptionally(exception -> Optional.empty());
    }

    public CompletableFuture<Void> addIssueLink(Link var1);

    public CompletableFuture<Void> deleteIssueLink(String var1);
}

