/*
 * Decompiled with CFR 0.152.
 */
package com.chavaillaz.client.jira.api;

import com.chavaillaz.client.jira.domain.Components;
import com.chavaillaz.client.jira.domain.Identity;
import com.chavaillaz.client.jira.domain.Project;
import com.chavaillaz.client.jira.domain.ProjectChange;
import com.chavaillaz.client.jira.domain.Projects;
import com.chavaillaz.client.jira.domain.Roles;
import com.chavaillaz.client.jira.domain.Statuses;
import com.chavaillaz.client.jira.domain.Versions;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public interface ProjectApi
extends AutoCloseable {
    public static final String URL_PROJECTS = "project";
    public static final String URL_PROJECTS_DETAILS = "project?includeArchived={0}&expand={1}";
    public static final String URL_PROJECT = "project/{0}";
    public static final String URL_PROJECT_VERSIONS = "project/{0}/versions";
    public static final String URL_PROJECT_COMPONENTS = "project/{0}/components";
    public static final String URL_PROJECT_STATUSES = "project/{0}/statuses";
    public static final String URL_PROJECT_ROLES = "project/{0}/role";

    public CompletableFuture<Identity> addProject(ProjectChange var1);

    default public CompletableFuture<Projects> getProjects() {
        return this.getProjects(false, null);
    }

    public CompletableFuture<Projects> getProjects(boolean var1, String var2);

    public CompletableFuture<Project> getProject(String var1);

    default public CompletableFuture<Optional<Project>> getProjectOptional(String projectKey) {
        return ((CompletableFuture)this.getProject(projectKey).thenApply(Optional::of)).exceptionally(exception -> Optional.empty());
    }

    public CompletableFuture<Versions> getProjectVersions(String var1);

    public CompletableFuture<Components> getProjectComponents(String var1);

    public CompletableFuture<Statuses> getProjectStatuses(String var1);

    public CompletableFuture<Roles> getProjectRoles(String var1);

    public CompletableFuture<Project> updateProject(String var1, ProjectChange var2);

    public CompletableFuture<Void> deleteProject(String var1);
}

