/*
 * Decompiled with CFR 0.152.
 */
package com.chavaillaz.client.jira.api;

import com.chavaillaz.client.jira.api.IssueApi;
import com.chavaillaz.client.jira.api.expand.IssueExpand;
import com.chavaillaz.client.jira.domain.Filter;
import com.chavaillaz.client.jira.domain.Filters;
import com.chavaillaz.client.jira.domain.Issue;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;

public interface SearchApi<T extends List<? extends Issue>>
extends AutoCloseable {
    public static final String URL_SEARCH = "search";
    public static final String URL_FILTERS = "filter";
    public static final String URL_FILTER = "filter/{0}";
    public static final String URL_FILTER_FAVOURITE = "filter/favourite";

    default public CompletableFuture<T> getIssues(Set<String> issuesKey) {
        return this.getIssues(issuesKey, IssueApi.ALL_FIELDS);
    }

    default public CompletableFuture<T> getIssues(Set<String> issuesKey, Set<String> fields) {
        String jql = issuesKey == null || issuesKey.isEmpty() ? "" : "issue in (" + StringUtils.join(issuesKey, (String)",") + ")";
        Integer size = issuesKey == null ? 0 : issuesKey.size();
        return this.searchIssues(jql, 0, size, Collections.emptySet(), fields);
    }

    default public CompletableFuture<T> searchIssues(String jql) {
        return this.searchIssues(jql, 0, 50);
    }

    default public CompletableFuture<T> searchIssues(String jql, Integer startAt, Integer maxResults) {
        return this.searchIssues(jql, startAt, maxResults, Collections.emptySet());
    }

    default public CompletableFuture<T> searchIssues(String jql, Integer startAt, Integer maxResults, Set<IssueExpand> expand) {
        return this.searchIssues(jql, startAt, maxResults, expand, IssueApi.ALL_FIELDS);
    }

    public CompletableFuture<T> searchIssues(String var1, Integer var2, Integer var3, Set<IssueExpand> var4, Set<String> var5);

    public CompletableFuture<Filter> addFilter(Filter var1);

    public CompletableFuture<Filter> getFilter(String var1);

    default public CompletableFuture<Optional<Filter>> getFilterOptional(String id) {
        return ((CompletableFuture)this.getFilter(id).thenApply(Optional::of)).exceptionally(exception -> Optional.empty());
    }

    public CompletableFuture<Filters> getFavoriteFilters();

    public CompletableFuture<Filter> updateFilter(String var1, Filter var2);

    public CompletableFuture<Void> deleteFilter(String var1);
}

