/*
 * Decompiled with CFR 0.152.
 */
package com.chavaillaz.client.jira.api;

import com.chavaillaz.client.jira.domain.User;
import com.chavaillaz.client.jira.domain.Users;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public interface UserApi
extends AutoCloseable {
    public static final String URL_CURRENT_USER = "myself";
    public static final String URL_USER = "user?username={0}";
    public static final String URL_USERS_SEARCH = "user/search?username={0}&startAt={1}&maxResults={2}&includeInactive={3}";
    public static final String URL_USERS_ISSUE_ASSIGNABLE = "user/assignable/search?username={0}&issueKey={1}&startAt={2}&maxResults={3}&includeInactive={4}";
    public static final String URL_USERS_PROJECT_ASSIGNABLE = "user/assignable/search?username={0}&project={1}&startAt={2}&maxResults={3}&includeInactive={4}";

    default public CompletableFuture<Users> getUsers(String search) {
        return this.getUsers(search, 0, 50, false);
    }

    public CompletableFuture<Users> getUsers(String var1, Integer var2, Integer var3, Boolean var4);

    default public CompletableFuture<Users> getAssignableUsers(String search, String key) {
        return this.getAssignableUsers(search, key, 0, 50, false);
    }

    public CompletableFuture<Users> getAssignableUsers(String var1, String var2, Integer var3, Integer var4, Boolean var5);

    public CompletableFuture<User> getUser(String var1);

    default public CompletableFuture<Optional<User>> getUserOptional(String username) {
        return ((CompletableFuture)this.getUser(username).thenApply(Optional::of)).exceptionally(exception -> Optional.empty());
    }

    public CompletableFuture<User> getCurrentUser();
}

