/*
 * Decompiled with CFR 0.152.
 */
package com.chavaillaz.client.jira.domain;

import com.chavaillaz.client.jira.domain.BasicIssue;
import com.chavaillaz.client.jira.domain.ChangeLog;
import com.chavaillaz.client.jira.domain.Fields;
import com.chavaillaz.client.jira.domain.IssueType;
import com.chavaillaz.client.jira.domain.Project;
import com.chavaillaz.client.jira.domain.Transition;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.List;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Issue
extends BasicIssue {
    private ChangeLog changelog;
    private Fields fields;
    private List<Transition> transitions;

    public static Issue fromKey(String key) {
        Issue issue = new Issue();
        issue.setKey(key);
        issue.setFields(new Fields());
        return issue;
    }

    public static Issue from(String type, String project, String summary) {
        Issue issue = new Issue();
        Fields fields = new Fields();
        fields.setIssueType(IssueType.fromName(type));
        fields.setProject(Project.fromKey(project));
        fields.setSummary(summary);
        issue.setFields(fields);
        return issue;
    }

    @Generated
    public Issue() {
    }

    @Generated
    public ChangeLog getChangelog() {
        return this.changelog;
    }

    @Override
    @Generated
    public Fields getFields() {
        return this.fields;
    }

    @Generated
    public List<Transition> getTransitions() {
        return this.transitions;
    }

    @Generated
    public void setChangelog(ChangeLog changelog) {
        this.changelog = changelog;
    }

    @Generated
    public void setFields(Fields fields) {
        this.fields = fields;
    }

    @Generated
    public void setTransitions(List<Transition> transitions) {
        this.transitions = transitions;
    }

    @Override
    @Generated
    public String toString() {
        return "Issue(super=" + super.toString() + ", changelog=" + String.valueOf(this.getChangelog()) + ", fields=" + String.valueOf(this.getFields()) + ", transitions=" + String.valueOf(this.getTransitions()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Issue)) {
            return false;
        }
        Issue other = (Issue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ChangeLog this$changelog = this.getChangelog();
        ChangeLog other$changelog = other.getChangelog();
        if (this$changelog == null ? other$changelog != null : !((Object)this$changelog).equals(other$changelog)) {
            return false;
        }
        Fields this$fields = this.getFields();
        Fields other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        List<Transition> this$transitions = this.getTransitions();
        List<Transition> other$transitions = other.getTransitions();
        return !(this$transitions == null ? other$transitions != null : !((Object)this$transitions).equals(other$transitions));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Issue;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ChangeLog $changelog = this.getChangelog();
        result = result * 59 + ($changelog == null ? 43 : ((Object)$changelog).hashCode());
        Fields $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        List<Transition> $transitions = this.getTransitions();
        result = result * 59 + ($transitions == null ? 43 : ((Object)$transitions).hashCode());
        return result;
    }
}

