/*
 * Decompiled with CFR 0.152.
 */
package com.chavaillaz.client.jira.domain;

import com.chavaillaz.client.jira.domain.BasicIssue;
import com.chavaillaz.client.jira.domain.LinkType;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Link {
    private String id;
    private BasicIssue inwardIssue;
    private BasicIssue outwardIssue;
    private String self;
    private LinkType type;

    public static Link from(String type, String inwardIssue, String outwardIssue) {
        return Link.from(LinkType.fromName(type), BasicIssue.fromKey(inwardIssue), BasicIssue.fromKey(outwardIssue));
    }

    public static Link from(LinkType type, String inwardIssue, String outwardIssue) {
        return Link.from(type, BasicIssue.fromKey(inwardIssue), BasicIssue.fromKey(outwardIssue));
    }

    public static Link from(LinkType type, BasicIssue inwardIssue, BasicIssue outwardIssue) {
        Link link = new Link();
        link.setType(type);
        link.setInwardIssue(inwardIssue);
        link.setOutwardIssue(outwardIssue);
        return link;
    }

    @Generated
    public Link() {
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public BasicIssue getInwardIssue() {
        return this.inwardIssue;
    }

    @Generated
    public BasicIssue getOutwardIssue() {
        return this.outwardIssue;
    }

    @Generated
    public String getSelf() {
        return this.self;
    }

    @Generated
    public LinkType getType() {
        return this.type;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setInwardIssue(BasicIssue inwardIssue) {
        this.inwardIssue = inwardIssue;
    }

    @Generated
    public void setOutwardIssue(BasicIssue outwardIssue) {
        this.outwardIssue = outwardIssue;
    }

    @Generated
    public void setSelf(String self) {
        this.self = self;
    }

    @Generated
    public void setType(LinkType type) {
        this.type = type;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Link)) {
            return false;
        }
        Link other = (Link)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        BasicIssue this$inwardIssue = this.getInwardIssue();
        BasicIssue other$inwardIssue = other.getInwardIssue();
        if (this$inwardIssue == null ? other$inwardIssue != null : !((Object)this$inwardIssue).equals(other$inwardIssue)) {
            return false;
        }
        BasicIssue this$outwardIssue = this.getOutwardIssue();
        BasicIssue other$outwardIssue = other.getOutwardIssue();
        if (this$outwardIssue == null ? other$outwardIssue != null : !((Object)this$outwardIssue).equals(other$outwardIssue)) {
            return false;
        }
        String this$self = this.getSelf();
        String other$self = other.getSelf();
        if (this$self == null ? other$self != null : !this$self.equals(other$self)) {
            return false;
        }
        LinkType this$type = this.getType();
        LinkType other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)this$type).equals(other$type));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Link;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        BasicIssue $inwardIssue = this.getInwardIssue();
        result = result * 59 + ($inwardIssue == null ? 43 : ((Object)$inwardIssue).hashCode());
        BasicIssue $outwardIssue = this.getOutwardIssue();
        result = result * 59 + ($outwardIssue == null ? 43 : ((Object)$outwardIssue).hashCode());
        String $self = this.getSelf();
        result = result * 59 + ($self == null ? 43 : $self.hashCode());
        LinkType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Link(id=" + this.getId() + ", inwardIssue=" + String.valueOf(this.getInwardIssue()) + ", outwardIssue=" + String.valueOf(this.getOutwardIssue()) + ", self=" + this.getSelf() + ", type=" + String.valueOf(this.getType()) + ")";
    }
}

