/*
 * Decompiled with CFR 0.152.
 */
package com.chavaillaz.client.jira.domain;

import com.chavaillaz.client.jira.domain.Identity;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.lang.module.ModuleDescriptor;
import java.time.LocalDate;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Version
extends Identity {
    private Boolean archived;
    private String description;
    private Boolean overdue;
    private Integer projectId;
    private LocalDate releaseDate;
    private Boolean released;

    public static Version fromId(String id) {
        Version version = new Version();
        version.setId(id);
        return version;
    }

    public static Version fromName(String name) {
        Version version = new Version();
        version.setName(name);
        return version;
    }

    public static Version from(String id, String name) {
        Version version = new Version();
        version.setId(id);
        version.setName(name);
        return version;
    }

    @Override
    public int compareTo(Identity other) {
        try {
            ModuleDescriptor.Version version = ModuleDescriptor.Version.parse(this.getName());
            ModuleDescriptor.Version versionOther = ModuleDescriptor.Version.parse(other.getName());
            return version.compareTo(versionOther);
        }
        catch (Exception e) {
            return super.compareTo(other);
        }
    }

    @Generated
    public Version() {
    }

    @Generated
    public Boolean getArchived() {
        return this.archived;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Boolean getOverdue() {
        return this.overdue;
    }

    @Generated
    public Integer getProjectId() {
        return this.projectId;
    }

    @Generated
    public LocalDate getReleaseDate() {
        return this.releaseDate;
    }

    @Generated
    public Boolean getReleased() {
        return this.released;
    }

    @Generated
    public void setArchived(Boolean archived) {
        this.archived = archived;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setOverdue(Boolean overdue) {
        this.overdue = overdue;
    }

    @Generated
    public void setProjectId(Integer projectId) {
        this.projectId = projectId;
    }

    @Generated
    public void setReleaseDate(LocalDate releaseDate) {
        this.releaseDate = releaseDate;
    }

    @Generated
    public void setReleased(Boolean released) {
        this.released = released;
    }

    @Override
    @Generated
    public String toString() {
        return "Version(super=" + super.toString() + ", archived=" + this.getArchived() + ", description=" + this.getDescription() + ", overdue=" + this.getOverdue() + ", projectId=" + this.getProjectId() + ", releaseDate=" + String.valueOf(this.getReleaseDate()) + ", released=" + this.getReleased() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Version)) {
            return false;
        }
        Version other = (Version)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$archived = this.getArchived();
        Boolean other$archived = other.getArchived();
        if (this$archived == null ? other$archived != null : !((Object)this$archived).equals(other$archived)) {
            return false;
        }
        Boolean this$overdue = this.getOverdue();
        Boolean other$overdue = other.getOverdue();
        if (this$overdue == null ? other$overdue != null : !((Object)this$overdue).equals(other$overdue)) {
            return false;
        }
        Integer this$projectId = this.getProjectId();
        Integer other$projectId = other.getProjectId();
        if (this$projectId == null ? other$projectId != null : !((Object)this$projectId).equals(other$projectId)) {
            return false;
        }
        Boolean this$released = this.getReleased();
        Boolean other$released = other.getReleased();
        if (this$released == null ? other$released != null : !((Object)this$released).equals(other$released)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        LocalDate this$releaseDate = this.getReleaseDate();
        LocalDate other$releaseDate = other.getReleaseDate();
        return !(this$releaseDate == null ? other$releaseDate != null : !((Object)this$releaseDate).equals(other$releaseDate));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Version;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $archived = this.getArchived();
        result = result * 59 + ($archived == null ? 43 : ((Object)$archived).hashCode());
        Boolean $overdue = this.getOverdue();
        result = result * 59 + ($overdue == null ? 43 : ((Object)$overdue).hashCode());
        Integer $projectId = this.getProjectId();
        result = result * 59 + ($projectId == null ? 43 : ((Object)$projectId).hashCode());
        Boolean $released = this.getReleased();
        result = result * 59 + ($released == null ? 43 : ((Object)$released).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        LocalDate $releaseDate = this.getReleaseDate();
        result = result * 59 + ($releaseDate == null ? 43 : ((Object)$releaseDate).hashCode());
        return result;
    }
}

