/*
 * Decompiled with CFR 0.152.
 */
package com.chavaillaz.client.jira.domain;

import com.chavaillaz.client.jira.domain.User;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.time.OffsetDateTime;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
public class WorkLog
implements Comparable<WorkLog> {
    private User author;
    private String comment;
    private String created;
    private String id;
    private String issueId;
    private String self;
    private OffsetDateTime started;
    private String timeSpent;
    private Integer timeSpentSeconds;
    private User updateAuthor;
    private OffsetDateTime updated;

    public static WorkLog fromHours(Double timeHours, String comment) {
        return WorkLog.fromHours(OffsetDateTime.now(), timeHours, comment);
    }

    public static WorkLog fromHours(OffsetDateTime date, Double timeHours, String comment) {
        WorkLog workLog = new WorkLog();
        workLog.setStarted(date);
        workLog.setTimeSpentSeconds((int)(timeHours * 60.0 * 60.0));
        workLog.setComment(comment);
        return workLog;
    }

    @Override
    public int compareTo(WorkLog other) {
        return this.getStarted().compareTo(other.getStarted());
    }

    @Generated
    public WorkLog() {
    }

    @Generated
    public User getAuthor() {
        return this.author;
    }

    @Generated
    public String getComment() {
        return this.comment;
    }

    @Generated
    public String getCreated() {
        return this.created;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getIssueId() {
        return this.issueId;
    }

    @Generated
    public String getSelf() {
        return this.self;
    }

    @Generated
    public OffsetDateTime getStarted() {
        return this.started;
    }

    @Generated
    public String getTimeSpent() {
        return this.timeSpent;
    }

    @Generated
    public Integer getTimeSpentSeconds() {
        return this.timeSpentSeconds;
    }

    @Generated
    public User getUpdateAuthor() {
        return this.updateAuthor;
    }

    @Generated
    public OffsetDateTime getUpdated() {
        return this.updated;
    }

    @Generated
    public void setAuthor(User author) {
        this.author = author;
    }

    @Generated
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Generated
    public void setCreated(String created) {
        this.created = created;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setIssueId(String issueId) {
        this.issueId = issueId;
    }

    @Generated
    public void setSelf(String self) {
        this.self = self;
    }

    @Generated
    public void setStarted(OffsetDateTime started) {
        this.started = started;
    }

    @Generated
    public void setTimeSpent(String timeSpent) {
        this.timeSpent = timeSpent;
    }

    @Generated
    public void setTimeSpentSeconds(Integer timeSpentSeconds) {
        this.timeSpentSeconds = timeSpentSeconds;
    }

    @Generated
    public void setUpdateAuthor(User updateAuthor) {
        this.updateAuthor = updateAuthor;
    }

    @Generated
    public void setUpdated(OffsetDateTime updated) {
        this.updated = updated;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkLog)) {
            return false;
        }
        WorkLog other = (WorkLog)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$timeSpentSeconds = this.getTimeSpentSeconds();
        Integer other$timeSpentSeconds = other.getTimeSpentSeconds();
        if (this$timeSpentSeconds == null ? other$timeSpentSeconds != null : !((Object)this$timeSpentSeconds).equals(other$timeSpentSeconds)) {
            return false;
        }
        User this$author = this.getAuthor();
        User other$author = other.getAuthor();
        if (this$author == null ? other$author != null : !((Object)this$author).equals(other$author)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        String this$created = this.getCreated();
        String other$created = other.getCreated();
        if (this$created == null ? other$created != null : !this$created.equals(other$created)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$issueId = this.getIssueId();
        String other$issueId = other.getIssueId();
        if (this$issueId == null ? other$issueId != null : !this$issueId.equals(other$issueId)) {
            return false;
        }
        String this$self = this.getSelf();
        String other$self = other.getSelf();
        if (this$self == null ? other$self != null : !this$self.equals(other$self)) {
            return false;
        }
        OffsetDateTime this$started = this.getStarted();
        OffsetDateTime other$started = other.getStarted();
        if (this$started == null ? other$started != null : !((Object)this$started).equals(other$started)) {
            return false;
        }
        String this$timeSpent = this.getTimeSpent();
        String other$timeSpent = other.getTimeSpent();
        if (this$timeSpent == null ? other$timeSpent != null : !this$timeSpent.equals(other$timeSpent)) {
            return false;
        }
        User this$updateAuthor = this.getUpdateAuthor();
        User other$updateAuthor = other.getUpdateAuthor();
        if (this$updateAuthor == null ? other$updateAuthor != null : !((Object)this$updateAuthor).equals(other$updateAuthor)) {
            return false;
        }
        OffsetDateTime this$updated = this.getUpdated();
        OffsetDateTime other$updated = other.getUpdated();
        return !(this$updated == null ? other$updated != null : !((Object)this$updated).equals(other$updated));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WorkLog;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $timeSpentSeconds = this.getTimeSpentSeconds();
        result = result * 59 + ($timeSpentSeconds == null ? 43 : ((Object)$timeSpentSeconds).hashCode());
        User $author = this.getAuthor();
        result = result * 59 + ($author == null ? 43 : ((Object)$author).hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        String $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : $created.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $issueId = this.getIssueId();
        result = result * 59 + ($issueId == null ? 43 : $issueId.hashCode());
        String $self = this.getSelf();
        result = result * 59 + ($self == null ? 43 : $self.hashCode());
        OffsetDateTime $started = this.getStarted();
        result = result * 59 + ($started == null ? 43 : ((Object)$started).hashCode());
        String $timeSpent = this.getTimeSpent();
        result = result * 59 + ($timeSpent == null ? 43 : $timeSpent.hashCode());
        User $updateAuthor = this.getUpdateAuthor();
        result = result * 59 + ($updateAuthor == null ? 43 : ((Object)$updateAuthor).hashCode());
        OffsetDateTime $updated = this.getUpdated();
        result = result * 59 + ($updated == null ? 43 : ((Object)$updated).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "WorkLog(author=" + String.valueOf(this.getAuthor()) + ", comment=" + this.getComment() + ", created=" + this.getCreated() + ", id=" + this.getId() + ", issueId=" + this.getIssueId() + ", self=" + this.getSelf() + ", started=" + String.valueOf(this.getStarted()) + ", timeSpent=" + this.getTimeSpent() + ", timeSpentSeconds=" + this.getTimeSpentSeconds() + ", updateAuthor=" + String.valueOf(this.getUpdateAuthor()) + ", updated=" + String.valueOf(this.getUpdated()) + ")";
    }
}

