/*
 * Decompiled with CFR 0.152.
 */
package com.chavaillaz.client.jira.exception;

import com.chavaillaz.client.common.exception.ResponseException;
import com.chavaillaz.client.jira.JiraConstants;
import java.util.Optional;

public class JiraResponseException
extends ResponseException {
    public JiraResponseException(int code, String body) {
        super(code, body, JiraResponseException.errorMessage(code, body));
    }

    public JiraResponseException(String method, String url, int code, String body) {
        super(code, url, JiraResponseException.errorMessage(code, body) + " for " + method + " " + url);
    }

    private static String errorMessage(Integer code, String content) {
        return "Jira responded with " + code + ": " + Optional.ofNullable(JiraConstants.extractJsonErrors(content)).map(errors -> String.join((CharSequence)". ", errors)).or(() -> Optional.ofNullable(JiraConstants.extractHtmlErrors(content))).orElse(content);
    }
}

