/*
 * Decompiled with CFR 0.152.
 */
package com.chavaillaz.client.jira.java;

import com.chavaillaz.client.common.java.JavaHttpUtils;
import com.chavaillaz.client.common.security.Authentication;
import com.chavaillaz.client.jira.api.IssueApi;
import com.chavaillaz.client.jira.api.expand.CommentExpand;
import com.chavaillaz.client.jira.api.expand.IssueExpand;
import com.chavaillaz.client.jira.domain.Attachment;
import com.chavaillaz.client.jira.domain.Attachments;
import com.chavaillaz.client.jira.domain.Comment;
import com.chavaillaz.client.jira.domain.Comments;
import com.chavaillaz.client.jira.domain.Identity;
import com.chavaillaz.client.jira.domain.Issue;
import com.chavaillaz.client.jira.domain.IssueTransition;
import com.chavaillaz.client.jira.domain.Link;
import com.chavaillaz.client.jira.domain.RemoteLink;
import com.chavaillaz.client.jira.domain.RemoteLinks;
import com.chavaillaz.client.jira.domain.Transitions;
import com.chavaillaz.client.jira.domain.User;
import com.chavaillaz.client.jira.domain.Votes;
import com.chavaillaz.client.jira.domain.Watchers;
import com.chavaillaz.client.jira.domain.WorkLog;
import com.chavaillaz.client.jira.domain.WorkLogs;
import com.chavaillaz.client.jira.java.AbstractJavaHttpClient;
import java.io.File;
import java.io.InputStream;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.RandomStringUtils;

public class JavaHttpIssueApi<T extends Issue>
extends AbstractJavaHttpClient
implements IssueApi<T> {
    protected final Class<T> issueType;

    public JavaHttpIssueApi(HttpClient client, String baseUrl, Authentication authentication, Class<T> issueType) {
        super(client, baseUrl, authentication);
        this.issueType = issueType;
    }

    @Override
    public CompletableFuture<Identity> addIssue(T issue) {
        return this.sendAsync(this.requestBuilder("issue/", new Object[0]).POST(this.body(issue)), Identity.class);
    }

    @Override
    public CompletableFuture<T> getIssue(String issueKey, Set<IssueExpand> expandFlags, Set<String> fields) {
        return this.sendAsync(this.requestBuilder("issue/{0}?expand={1}&fields={2}", new Object[]{issueKey, IssueExpand.asParameter(expandFlags), String.join((CharSequence)",", fields)}).GET(), this.issueType);
    }

    @Override
    public CompletableFuture<Void> updateIssue(T issue) {
        return this.sendAsync(this.requestBuilder("issue/{0}", new Object[]{((Identity)issue).getKey()}).PUT(this.body(issue)), Void.class);
    }

    @Override
    public CompletableFuture<Void> deleteIssue(String issueKey) {
        return this.sendAsync(this.requestBuilder("issue/{0}", new Object[]{issueKey}).DELETE(), Void.class);
    }

    @Override
    public CompletableFuture<Void> assignIssue(String issueKey, User user) {
        return this.sendAsync(this.requestBuilder("issue/{0}/assignee", new Object[]{issueKey}).PUT(this.body(user)), Void.class);
    }

    @Override
    public CompletableFuture<Transitions> getTransitions(String issueKey) {
        return this.sendAsync(this.requestBuilder("issue/{0}/transitions", new Object[]{issueKey}).GET(), Transitions.class);
    }

    @Override
    public CompletableFuture<Void> doTransition(String issueKey, IssueTransition<?> transition) {
        return this.sendAsync(this.requestBuilder("issue/{0}/transitions", new Object[]{issueKey}).POST(this.body(transition)), Void.class);
    }

    @Override
    public CompletableFuture<Comments> getComments(String issueKey, Integer startAt, Integer maxResults, Set<CommentExpand> expandFlags) {
        return this.sendAsync(this.requestBuilder("issue/{0}/comment?startAt={1}&maxResults={2}&expand={3}", new Object[]{issueKey, startAt, maxResults, CommentExpand.asParameter(expandFlags)}).GET(), Comments.class);
    }

    @Override
    public CompletableFuture<Comment> getComment(String issueKey, String id, Set<CommentExpand> expandFlags) {
        return this.sendAsync(this.requestBuilder("issue/{0}/comment/{1}?expand={2}", new Object[]{issueKey, id, CommentExpand.asParameter(expandFlags)}).GET(), Comment.class);
    }

    @Override
    public CompletableFuture<Comment> addComment(String issueKey, Comment comment) {
        return this.sendAsync(this.requestBuilder("issue/{0}/comment", new Object[]{issueKey}).POST(this.body(comment)), Comment.class);
    }

    @Override
    public CompletableFuture<Comment> updateComment(String issueKey, Comment comment) {
        return this.sendAsync(this.requestBuilder("issue/{0}/comment/{1}", new Object[]{issueKey, comment.getId()}).PUT(this.body(comment)), Comment.class);
    }

    @Override
    public CompletableFuture<Void> deleteComment(String issueKey, String id) {
        return this.sendAsync(this.requestBuilder("issue/{0}/comment/{1}", new Object[]{issueKey, id}).DELETE(), Void.class);
    }

    @Override
    public CompletableFuture<Void> addVote(String issueKey) {
        return this.sendAsync(this.requestBuilder("issue/{0}/votes", new Object[]{issueKey}).POST(HttpRequest.BodyPublishers.noBody()), Void.class);
    }

    @Override
    public CompletableFuture<Votes> getVotes(String issueKey) {
        return this.sendAsync(this.requestBuilder("issue/{0}/votes", new Object[]{issueKey}).GET(), Votes.class);
    }

    @Override
    public CompletableFuture<Watchers> getWatchers(String issueKey) {
        return this.sendAsync(this.requestBuilder("issue/{0}/watchers", new Object[]{issueKey}).GET(), Watchers.class);
    }

    @Override
    public CompletableFuture<Void> addWatcher(String issueKey, String username) {
        return this.sendAsync(this.requestBuilder("issue/{0}/watchers", new Object[]{issueKey}).POST(this.body(username)), Void.class);
    }

    @Override
    public CompletableFuture<Void> deleteWatcher(String issueKey, String username) {
        return this.sendAsync(this.requestBuilder("issue/{0}/watchers?username={1}", new Object[]{issueKey, username}).DELETE(), Void.class);
    }

    @Override
    public CompletableFuture<WorkLog> addWorkLog(String issueKey, WorkLog workLog) {
        return this.sendAsync(this.requestBuilder("issue/{0}/worklog", new Object[]{issueKey}).POST(this.body(workLog)), WorkLog.class);
    }

    @Override
    public CompletableFuture<WorkLogs> getWorkLogs(String issueKey) {
        return this.sendAsync(this.requestBuilder("issue/{0}/worklog", new Object[]{issueKey}).GET(), WorkLogs.class);
    }

    @Override
    public CompletableFuture<WorkLog> getWorkLog(String issueKey, String id) {
        return this.sendAsync(this.requestBuilder("issue/{0}/worklog/{1}", new Object[]{issueKey, id}).GET(), WorkLog.class);
    }

    @Override
    public CompletableFuture<WorkLog> updateWorkLog(String issueKey, WorkLog workLog) {
        return this.sendAsync(this.requestBuilder("issue/{0}/worklog/{1}", new Object[]{issueKey, workLog.getId()}).PUT(this.body(workLog)), WorkLog.class);
    }

    @Override
    public CompletableFuture<Void> deleteWorkLog(String issueKey, String id) {
        return this.sendAsync(this.requestBuilder("issue/{0}/worklog/{1}", new Object[]{issueKey, id}).DELETE(), Void.class);
    }

    @Override
    public CompletableFuture<Attachment> getAttachment(String id) {
        return this.sendAsync(this.requestBuilder("attachment/{0}", new Object[]{id}).GET(), Attachment.class);
    }

    @Override
    public CompletableFuture<InputStream> getAttachmentContent(String url) {
        return this.sendAsync(this.requestBuilder(url, new Object[0]).GET());
    }

    @Override
    public CompletableFuture<Attachments> addAttachment(String issueKey, File ... files) {
        String boundary = RandomStringUtils.randomAlphanumeric((int)16);
        HttpRequest.Builder request = this.requestBuilder("issue/{0}/attachments", new Object[]{issueKey}).setHeader("Content-Type", "multipart/form-data; boundary=" + boundary).setHeader("X-Atlassian-Token", "no-check").POST(JavaHttpUtils.mimeMultipartData((Map)JavaHttpUtils.multipartWithFiles((File[])files), (String)boundary, (Charset)StandardCharsets.UTF_8));
        return this.sendAsync(request, Attachments.class);
    }

    @Override
    public CompletableFuture<Void> deleteAttachment(String id) {
        return this.sendAsync(this.requestBuilder("attachment/{0}", new Object[]{id}).DELETE(), Void.class);
    }

    @Override
    public CompletableFuture<RemoteLinks> getRemoteLinks(String issueKey) {
        return this.sendAsync(this.requestBuilder("issue/{0}/remotelink", new Object[]{issueKey}).GET(), RemoteLinks.class);
    }

    @Override
    public CompletableFuture<RemoteLink> getRemoteLink(String issueKey, String id) {
        return this.sendAsync(this.requestBuilder("issue/{0}/remotelink/{1}", new Object[]{issueKey, id}).GET(), RemoteLink.class);
    }

    @Override
    public CompletableFuture<Identity> addRemoteLink(String issueKey, RemoteLink remoteLink) {
        return this.sendAsync(this.requestBuilder("issue/{0}/remotelink", new Object[]{issueKey}).POST(this.body(remoteLink)), Identity.class);
    }

    @Override
    public CompletableFuture<Void> updateRemoteLink(String issueKey, RemoteLink remoteLink) {
        return this.sendAsync(this.requestBuilder("issue/{0}/remotelink/{1}", new Object[]{issueKey, remoteLink.getId()}).PUT(this.body(remoteLink)), Void.class);
    }

    @Override
    public CompletableFuture<Void> deleteRemoteLink(String issueKey, String id) {
        return this.sendAsync(this.requestBuilder("issue/{0}/remotelink/{1}", new Object[]{issueKey, id}).DELETE(), Void.class);
    }

    @Override
    public CompletableFuture<Link> getIssueLink(String id) {
        return this.sendAsync(this.requestBuilder("issueLink/{0}", new Object[]{id}).GET(), Link.class);
    }

    @Override
    public CompletableFuture<Void> addIssueLink(Link link) {
        return this.sendAsync(this.requestBuilder("issueLink/", new Object[0]).POST(this.body(link)), Void.class);
    }

    @Override
    public CompletableFuture<Void> deleteIssueLink(String id) {
        return this.sendAsync(this.requestBuilder("issueLink/{0}", new Object[]{id}).DELETE(), Void.class);
    }
}

