/*
 * Decompiled with CFR 0.152.
 */
package com.chavaillaz.client.jira.java;

import com.chavaillaz.client.common.java.JavaHttpUtils;
import com.chavaillaz.client.common.utility.ProxyConfiguration;
import com.chavaillaz.client.jira.AbstractJiraClient;
import com.chavaillaz.client.jira.api.IssueApi;
import com.chavaillaz.client.jira.api.ProjectApi;
import com.chavaillaz.client.jira.api.SearchApi;
import com.chavaillaz.client.jira.api.UserApi;
import com.chavaillaz.client.jira.domain.Issue;
import com.chavaillaz.client.jira.domain.Issues;
import com.chavaillaz.client.jira.java.JavaHttpIssueApi;
import com.chavaillaz.client.jira.java.JavaHttpProjectApi;
import com.chavaillaz.client.jira.java.JavaHttpSearchApi;
import com.chavaillaz.client.jira.java.JavaHttpUserApi;
import java.net.http.HttpClient;

public class JavaHttpJiraClient<I extends Issue>
extends AbstractJiraClient<HttpClient, I> {
    public JavaHttpJiraClient(String jiraUrl, Class<I> issueType) {
        super(jiraUrl, issueType);
    }

    public HttpClient newHttpClient() {
        return JavaHttpUtils.defaultHttpClientBuilder((ProxyConfiguration)this.proxy).build();
    }

    @Override
    public IssueApi<I> getIssueApi() {
        return (IssueApi)this.issueApi.get(() -> new JavaHttpIssueApi(this.newHttpClient(), this.baseUrl + "/rest/api/2/", this.authentication, this.issueType));
    }

    @Override
    public ProjectApi getProjectApi() {
        return (ProjectApi)this.projectApi.get(() -> new JavaHttpProjectApi(this.newHttpClient(), this.baseUrl + "/rest/api/2/", this.authentication));
    }

    @Override
    public UserApi getUserApi() {
        return (UserApi)this.userApi.get(() -> new JavaHttpUserApi(this.newHttpClient(), this.baseUrl + "/rest/api/2/", this.authentication));
    }

    @Override
    public SearchApi<Issues<I>> getSearchApi() {
        return (SearchApi)this.searchApi.get(() -> new JavaHttpSearchApi(this.newHttpClient(), this.baseUrl + "/rest/api/2/", this.authentication, this.issuesListType));
    }
}

