/*
 * Decompiled with CFR 0.152.
 */
package com.chavaillaz.client.jira.java;

import com.chavaillaz.client.common.security.Authentication;
import com.chavaillaz.client.jira.api.ProjectApi;
import com.chavaillaz.client.jira.domain.Components;
import com.chavaillaz.client.jira.domain.Identity;
import com.chavaillaz.client.jira.domain.Project;
import com.chavaillaz.client.jira.domain.ProjectChange;
import com.chavaillaz.client.jira.domain.Projects;
import com.chavaillaz.client.jira.domain.Roles;
import com.chavaillaz.client.jira.domain.Statuses;
import com.chavaillaz.client.jira.domain.Versions;
import com.chavaillaz.client.jira.java.AbstractJavaHttpClient;
import java.net.http.HttpClient;
import java.util.concurrent.CompletableFuture;

public class JavaHttpProjectApi
extends AbstractJavaHttpClient
implements ProjectApi {
    public JavaHttpProjectApi(HttpClient client, String baseUrl, Authentication authentication) {
        super(client, baseUrl, authentication);
    }

    @Override
    public CompletableFuture<Identity> addProject(ProjectChange project) {
        return this.sendAsync(this.requestBuilder("project", new Object[0]).POST(this.body(project)), Identity.class);
    }

    @Override
    public CompletableFuture<Projects> getProjects(boolean includeArchived, String expand) {
        return this.sendAsync(this.requestBuilder("project?includeArchived={0}&expand={1}", new Object[]{includeArchived, expand}).GET(), Projects.class);
    }

    @Override
    public CompletableFuture<Project> getProject(String projectKey) {
        return this.sendAsync(this.requestBuilder("project/{0}", new Object[]{projectKey}).GET(), Project.class);
    }

    @Override
    public CompletableFuture<Versions> getProjectVersions(String projectKey) {
        return this.sendAsync(this.requestBuilder("project/{0}/versions", new Object[]{projectKey}).GET(), Versions.class);
    }

    @Override
    public CompletableFuture<Components> getProjectComponents(String projectKey) {
        return this.sendAsync(this.requestBuilder("project/{0}/components", new Object[]{projectKey}).GET(), Components.class);
    }

    @Override
    public CompletableFuture<Statuses> getProjectStatuses(String projectKey) {
        return this.sendAsync(this.requestBuilder("project/{0}/statuses", new Object[]{projectKey}).GET(), Statuses.class);
    }

    @Override
    public CompletableFuture<Roles> getProjectRoles(String projectKey) {
        return this.sendAsync(this.requestBuilder("project/{0}/role", new Object[]{projectKey}).GET(), Roles.class);
    }

    @Override
    public CompletableFuture<Project> updateProject(String projectKey, ProjectChange project) {
        return this.sendAsync(this.requestBuilder("project/{0}", new Object[]{projectKey}).PUT(this.body(project)), Project.class);
    }

    @Override
    public CompletableFuture<Void> deleteProject(String projectKey) {
        return this.sendAsync(this.requestBuilder("project/{0}", new Object[]{projectKey}).DELETE(), Void.class);
    }
}

