/*
 * Decompiled with CFR 0.152.
 */
package com.chavaillaz.client.jira.java;

import com.chavaillaz.client.common.security.Authentication;
import com.chavaillaz.client.jira.api.SearchApi;
import com.chavaillaz.client.jira.api.expand.IssueExpand;
import com.chavaillaz.client.jira.domain.Filter;
import com.chavaillaz.client.jira.domain.Filters;
import com.chavaillaz.client.jira.domain.Issue;
import com.chavaillaz.client.jira.domain.Query;
import com.chavaillaz.client.jira.java.AbstractJavaHttpClient;
import com.fasterxml.jackson.databind.JavaType;
import java.net.http.HttpClient;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public class JavaHttpSearchApi<T extends List<? extends Issue>>
extends AbstractJavaHttpClient
implements SearchApi<T> {
    protected final JavaType issuesListType;

    public JavaHttpSearchApi(HttpClient client, String baseUrl, Authentication authentication, JavaType issuesListType) {
        super(client, baseUrl, authentication);
        this.issuesListType = issuesListType;
    }

    @Override
    public CompletableFuture<T> searchIssues(String jql, Integer startAt, Integer maxResults, Set<IssueExpand> expand, Set<String> fields) {
        return this.sendAsync(this.requestBuilder("search", new Object[0]).POST(this.body(Query.from(jql, startAt, maxResults, expand, fields))), this.issuesListType);
    }

    @Override
    public CompletableFuture<Filter> addFilter(Filter filter) {
        return this.sendAsync(this.requestBuilder("filter", new Object[0]).POST(this.body(filter)), Filter.class);
    }

    @Override
    public CompletableFuture<Filter> getFilter(String id) {
        return this.sendAsync(this.requestBuilder("filter/{0}", new Object[]{id}).GET(), Filter.class);
    }

    @Override
    public CompletableFuture<Filters> getFavoriteFilters() {
        return this.sendAsync(this.requestBuilder("filter/favourite", new Object[0]).GET(), Filters.class);
    }

    @Override
    public CompletableFuture<Filter> updateFilter(String id, Filter filter) {
        return this.sendAsync(this.requestBuilder("filter/{0}", new Object[]{id}).PUT(this.body(filter)), Filter.class);
    }

    @Override
    public CompletableFuture<Void> deleteFilter(String id) {
        return this.sendAsync(this.requestBuilder("filter/{0}", new Object[]{id}).DELETE(), Void.class);
    }
}

