/*
 * Decompiled with CFR 0.152.
 */
package com.chavaillaz.client.jira.okhttp;

import com.chavaillaz.client.common.okhttp.OkHttpUtils;
import com.chavaillaz.client.common.utility.ProxyConfiguration;
import com.chavaillaz.client.jira.AbstractJiraClient;
import com.chavaillaz.client.jira.api.IssueApi;
import com.chavaillaz.client.jira.api.ProjectApi;
import com.chavaillaz.client.jira.api.SearchApi;
import com.chavaillaz.client.jira.api.UserApi;
import com.chavaillaz.client.jira.domain.Issue;
import com.chavaillaz.client.jira.domain.Issues;
import com.chavaillaz.client.jira.okhttp.OkHttpIssueApi;
import com.chavaillaz.client.jira.okhttp.OkHttpProjectApi;
import com.chavaillaz.client.jira.okhttp.OkHttpSearchApi;
import com.chavaillaz.client.jira.okhttp.OkHttpUserApi;
import okhttp3.OkHttpClient;

public class OkHttpJiraClient<I extends Issue>
extends AbstractJiraClient<OkHttpClient, I> {
    public OkHttpJiraClient(String jiraUrl, Class<I> issueType) {
        super(jiraUrl, issueType);
    }

    public OkHttpClient newHttpClient() {
        return OkHttpUtils.defaultHttpClientBuilder((ProxyConfiguration)this.proxy).build();
    }

    @Override
    public IssueApi<I> getIssueApi() {
        return (IssueApi)this.issueApi.get(() -> new OkHttpIssueApi(this.newHttpClient(), this.baseUrl + "/rest/api/2/", this.authentication, this.issueType));
    }

    @Override
    public ProjectApi getProjectApi() {
        return (ProjectApi)this.projectApi.get(() -> new OkHttpProjectApi(this.newHttpClient(), this.baseUrl + "/rest/api/2/", this.authentication));
    }

    @Override
    public UserApi getUserApi() {
        return (UserApi)this.userApi.get(() -> new OkHttpUserApi(this.newHttpClient(), this.baseUrl + "/rest/api/2/", this.authentication));
    }

    @Override
    public SearchApi<Issues<I>> getSearchApi() {
        return (SearchApi)this.searchApi.get(() -> new OkHttpSearchApi(this.newHttpClient(), this.baseUrl + "/rest/api/2/", this.authentication, this.issuesListType));
    }
}

