/*
 * Decompiled with CFR 0.152.
 */
package com.chavaillaz.client.jira.okhttp;

import com.chavaillaz.client.common.security.Authentication;
import com.chavaillaz.client.jira.api.ProjectApi;
import com.chavaillaz.client.jira.domain.Components;
import com.chavaillaz.client.jira.domain.Identity;
import com.chavaillaz.client.jira.domain.Project;
import com.chavaillaz.client.jira.domain.ProjectChange;
import com.chavaillaz.client.jira.domain.Projects;
import com.chavaillaz.client.jira.domain.Roles;
import com.chavaillaz.client.jira.domain.Statuses;
import com.chavaillaz.client.jira.domain.Versions;
import com.chavaillaz.client.jira.okhttp.AbstractOkHttpClient;
import java.util.concurrent.CompletableFuture;
import okhttp3.OkHttpClient;

public class OkHttpProjectApi
extends AbstractOkHttpClient
implements ProjectApi {
    public OkHttpProjectApi(OkHttpClient client, String baseUrl, Authentication authentication) {
        super(client, baseUrl, authentication);
    }

    @Override
    public CompletableFuture<Identity> addProject(ProjectChange project) {
        return this.sendAsync(this.requestBuilder("project", new Object[0]).post(this.body(project)), Identity.class);
    }

    @Override
    public CompletableFuture<Projects> getProjects(boolean includeArchived, String expand) {
        return this.sendAsync(this.requestBuilder("project?includeArchived={0}&expand={1}", new Object[]{includeArchived, expand}).get(), Projects.class);
    }

    @Override
    public CompletableFuture<Project> getProject(String projectKey) {
        return this.sendAsync(this.requestBuilder("project/{0}", new Object[]{projectKey}).get(), Project.class);
    }

    @Override
    public CompletableFuture<Versions> getProjectVersions(String projectKey) {
        return this.sendAsync(this.requestBuilder("project/{0}/versions", new Object[]{projectKey}).get(), Versions.class);
    }

    @Override
    public CompletableFuture<Components> getProjectComponents(String projectKey) {
        return this.sendAsync(this.requestBuilder("project/{0}/components", new Object[]{projectKey}).get(), Components.class);
    }

    @Override
    public CompletableFuture<Statuses> getProjectStatuses(String projectKey) {
        return this.sendAsync(this.requestBuilder("project/{0}/statuses", new Object[]{projectKey}).get(), Statuses.class);
    }

    @Override
    public CompletableFuture<Roles> getProjectRoles(String projectKey) {
        return this.sendAsync(this.requestBuilder("project/{0}/role", new Object[]{projectKey}).get(), Roles.class);
    }

    @Override
    public CompletableFuture<Project> updateProject(String projectKey, ProjectChange project) {
        return this.sendAsync(this.requestBuilder("project/{0}", new Object[]{projectKey}).put(this.body(project)), Project.class);
    }

    @Override
    public CompletableFuture<Void> deleteProject(String projectKey) {
        return this.sendAsync(this.requestBuilder("project/{0}", new Object[]{projectKey}).delete(), Void.class);
    }
}

