/*
 * Decompiled with CFR 0.152.
 */
package com.chavaillaz.client.jira.vertx;

import com.chavaillaz.client.common.security.Authentication;
import com.chavaillaz.client.common.vertx.VertxUtils;
import com.chavaillaz.client.jira.api.IssueApi;
import com.chavaillaz.client.jira.api.expand.CommentExpand;
import com.chavaillaz.client.jira.api.expand.IssueExpand;
import com.chavaillaz.client.jira.domain.Attachment;
import com.chavaillaz.client.jira.domain.Attachments;
import com.chavaillaz.client.jira.domain.Comment;
import com.chavaillaz.client.jira.domain.Comments;
import com.chavaillaz.client.jira.domain.Identity;
import com.chavaillaz.client.jira.domain.Issue;
import com.chavaillaz.client.jira.domain.IssueTransition;
import com.chavaillaz.client.jira.domain.Link;
import com.chavaillaz.client.jira.domain.RemoteLink;
import com.chavaillaz.client.jira.domain.RemoteLinks;
import com.chavaillaz.client.jira.domain.Transitions;
import com.chavaillaz.client.jira.domain.User;
import com.chavaillaz.client.jira.domain.Votes;
import com.chavaillaz.client.jira.domain.Watchers;
import com.chavaillaz.client.jira.domain.WorkLog;
import com.chavaillaz.client.jira.domain.WorkLogs;
import com.chavaillaz.client.jira.vertx.AbstractVertxHttpClient;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.client.WebClient;
import java.io.File;
import java.io.InputStream;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public class VertxHttpIssueApi<T extends Issue>
extends AbstractVertxHttpClient
implements IssueApi<T> {
    protected final Class<T> issueType;

    public VertxHttpIssueApi(WebClient client, String baseUrl, Authentication authentication, Class<T> issueType) {
        super(client, baseUrl, authentication);
        this.issueType = issueType;
    }

    @Override
    public CompletableFuture<Identity> addIssue(T issue) {
        return this.handleAsync(this.requestBuilder(HttpMethod.POST, "issue/", new Object[0]).sendBuffer(this.body(issue)), Identity.class);
    }

    @Override
    public CompletableFuture<T> getIssue(String issueKey, Set<IssueExpand> expandFlags, Set<String> fields) {
        return this.handleAsync(this.requestBuilder(HttpMethod.GET, "issue/{0}?expand={1}&fields={2}", new Object[]{issueKey, IssueExpand.asParameter(expandFlags), String.join((CharSequence)",", fields)}).send(), this.issueType);
    }

    @Override
    public CompletableFuture<Void> updateIssue(T issue) {
        return this.handleAsync(this.requestBuilder(HttpMethod.PUT, "issue/{0}", new Object[]{((Identity)issue).getKey()}).sendBuffer(this.body(issue)), Void.class);
    }

    @Override
    public CompletableFuture<Void> deleteIssue(String issueKey) {
        return this.handleAsync(this.requestBuilder(HttpMethod.DELETE, "issue/{0}", new Object[]{issueKey}).send(), Void.class);
    }

    @Override
    public CompletableFuture<Void> assignIssue(String issueKey, User user) {
        return this.handleAsync(this.requestBuilder(HttpMethod.PUT, "issue/{0}/assignee", new Object[]{issueKey}).sendBuffer(this.body(user)), Void.class);
    }

    @Override
    public CompletableFuture<Transitions> getTransitions(String issueKey) {
        return this.handleAsync(this.requestBuilder(HttpMethod.GET, "issue/{0}/transitions", new Object[]{issueKey}).send(), Transitions.class);
    }

    @Override
    public CompletableFuture<Void> doTransition(String issueKey, IssueTransition<?> transition) {
        return this.handleAsync(this.requestBuilder(HttpMethod.POST, "issue/{0}/transitions", new Object[]{issueKey}).sendBuffer(this.body(transition)), Void.class);
    }

    @Override
    public CompletableFuture<Comments> getComments(String issueKey, Integer startAt, Integer maxResults, Set<CommentExpand> expandFlags) {
        return this.handleAsync(this.requestBuilder(HttpMethod.GET, "issue/{0}/comment?startAt={1}&maxResults={2}&expand={3}", new Object[]{issueKey, startAt, maxResults, CommentExpand.asParameter(expandFlags)}).send(), Comments.class);
    }

    @Override
    public CompletableFuture<Comment> getComment(String issueKey, String id, Set<CommentExpand> expandFlags) {
        return this.handleAsync(this.requestBuilder(HttpMethod.GET, "issue/{0}/comment/{1}?expand={2}", new Object[]{issueKey, id, CommentExpand.asParameter(expandFlags)}).send(), Comment.class);
    }

    @Override
    public CompletableFuture<Comment> addComment(String issueKey, Comment comment) {
        return this.handleAsync(this.requestBuilder(HttpMethod.POST, "issue/{0}/comment", new Object[]{issueKey}).sendBuffer(this.body(comment)), Comment.class);
    }

    @Override
    public CompletableFuture<Comment> updateComment(String issueKey, Comment comment) {
        return this.handleAsync(this.requestBuilder(HttpMethod.PUT, "issue/{0}/comment/{1}", new Object[]{issueKey, comment.getId()}).sendBuffer(this.body(comment)), Comment.class);
    }

    @Override
    public CompletableFuture<Void> deleteComment(String issueKey, String id) {
        return this.handleAsync(this.requestBuilder(HttpMethod.DELETE, "issue/{0}/comment/{1}", new Object[]{issueKey, id}).send(), Void.class);
    }

    @Override
    public CompletableFuture<Void> addVote(String issueKey) {
        return this.handleAsync(this.requestBuilder(HttpMethod.POST, "issue/{0}/votes", new Object[]{issueKey}).send(), Void.class);
    }

    @Override
    public CompletableFuture<Votes> getVotes(String issueKey) {
        return this.handleAsync(this.requestBuilder(HttpMethod.GET, "issue/{0}/votes", new Object[]{issueKey}).send(), Votes.class);
    }

    @Override
    public CompletableFuture<Watchers> getWatchers(String issueKey) {
        return this.handleAsync(this.requestBuilder(HttpMethod.GET, "issue/{0}/watchers", new Object[]{issueKey}).send(), Watchers.class);
    }

    @Override
    public CompletableFuture<Void> addWatcher(String issueKey, String username) {
        return this.handleAsync(this.requestBuilder(HttpMethod.POST, "issue/{0}/watchers", new Object[]{issueKey}).sendBuffer(this.body(username)), Void.class);
    }

    @Override
    public CompletableFuture<Void> deleteWatcher(String issueKey, String username) {
        return this.handleAsync(this.requestBuilder(HttpMethod.DELETE, "issue/{0}/watchers?username={1}", new Object[]{issueKey, username}).send(), Void.class);
    }

    @Override
    public CompletableFuture<WorkLog> addWorkLog(String issueKey, WorkLog workLog) {
        return this.handleAsync(this.requestBuilder(HttpMethod.POST, "issue/{0}/worklog", new Object[]{issueKey}).sendBuffer(this.body(workLog)), WorkLog.class);
    }

    @Override
    public CompletableFuture<WorkLogs> getWorkLogs(String issueKey) {
        return this.handleAsync(this.requestBuilder(HttpMethod.GET, "issue/{0}/worklog", new Object[]{issueKey}).send(), WorkLogs.class);
    }

    @Override
    public CompletableFuture<WorkLog> getWorkLog(String issueKey, String id) {
        return this.handleAsync(this.requestBuilder(HttpMethod.GET, "issue/{0}/worklog/{1}", new Object[]{issueKey, id}).send(), WorkLog.class);
    }

    @Override
    public CompletableFuture<WorkLog> updateWorkLog(String issueKey, WorkLog workLog) {
        return this.handleAsync(this.requestBuilder(HttpMethod.PUT, "issue/{0}/worklog/{1}", new Object[]{issueKey, workLog.getId()}).sendBuffer(this.body(workLog)), WorkLog.class);
    }

    @Override
    public CompletableFuture<Void> deleteWorkLog(String issueKey, String id) {
        return this.handleAsync(this.requestBuilder(HttpMethod.DELETE, "issue/{0}/worklog/{1}", new Object[]{issueKey, id}).send(), Void.class);
    }

    @Override
    public CompletableFuture<Attachment> getAttachment(String id) {
        return this.handleAsync(this.requestBuilder(HttpMethod.GET, "attachment/{0}", new Object[]{id}).send(), Attachment.class);
    }

    @Override
    public CompletableFuture<InputStream> getAttachmentContent(String url) {
        return this.handleAsync(this.requestBuilder(HttpMethod.GET, url, new Object[0]).send());
    }

    @Override
    public CompletableFuture<Attachments> addAttachment(String issueKey, File ... files) {
        return this.handleAsync(this.requestBuilder(HttpMethod.POST, "issue/{0}/attachments", new Object[]{issueKey}).putHeader("Content-Type", "multipart/form-data").putHeader("X-Atlassian-Token", "no-check").sendMultipartForm(VertxUtils.multipartWithFiles((File[])files)), Attachments.class);
    }

    @Override
    public CompletableFuture<Void> deleteAttachment(String id) {
        return this.handleAsync(this.requestBuilder(HttpMethod.DELETE, "attachment/{0}", new Object[]{id}).send(), Void.class);
    }

    @Override
    public CompletableFuture<RemoteLinks> getRemoteLinks(String issueKey) {
        return this.handleAsync(this.requestBuilder(HttpMethod.GET, "issue/{0}/remotelink", new Object[]{issueKey}).send(), RemoteLinks.class);
    }

    @Override
    public CompletableFuture<RemoteLink> getRemoteLink(String issueKey, String id) {
        return this.handleAsync(this.requestBuilder(HttpMethod.GET, "issue/{0}/remotelink/{1}", new Object[]{issueKey, id}).send(), RemoteLink.class);
    }

    @Override
    public CompletableFuture<Identity> addRemoteLink(String issueKey, RemoteLink remoteLink) {
        return this.handleAsync(this.requestBuilder(HttpMethod.POST, "issue/{0}/remotelink", new Object[]{issueKey}).sendBuffer(this.body(remoteLink)), Identity.class);
    }

    @Override
    public CompletableFuture<Void> updateRemoteLink(String issueKey, RemoteLink remoteLink) {
        return this.handleAsync(this.requestBuilder(HttpMethod.PUT, "issue/{0}/remotelink/{1}", new Object[]{issueKey, remoteLink.getId()}).sendBuffer(this.body(remoteLink)), Void.class);
    }

    @Override
    public CompletableFuture<Void> deleteRemoteLink(String issueKey, String id) {
        return this.handleAsync(this.requestBuilder(HttpMethod.DELETE, "issue/{0}/remotelink/{1}", new Object[]{issueKey, id}).send(), Void.class);
    }

    @Override
    public CompletableFuture<Link> getIssueLink(String id) {
        return this.handleAsync(this.requestBuilder(HttpMethod.GET, "issueLink/{0}", new Object[]{id}).send(), Link.class);
    }

    @Override
    public CompletableFuture<Void> addIssueLink(Link link) {
        return this.handleAsync(this.requestBuilder(HttpMethod.POST, "issueLink/", new Object[0]).sendBuffer(this.body(link)), Void.class);
    }

    @Override
    public CompletableFuture<Void> deleteIssueLink(String id) {
        return this.handleAsync(this.requestBuilder(HttpMethod.DELETE, "issueLink/{0}", new Object[]{id}).send(), Void.class);
    }
}

