/*
 * Decompiled with CFR 0.152.
 */
package com.chavaillaz.client.jira.vertx;

import com.chavaillaz.client.common.utility.ProxyConfiguration;
import com.chavaillaz.client.common.vertx.VertxUtils;
import com.chavaillaz.client.jira.AbstractJiraClient;
import com.chavaillaz.client.jira.api.IssueApi;
import com.chavaillaz.client.jira.api.ProjectApi;
import com.chavaillaz.client.jira.api.SearchApi;
import com.chavaillaz.client.jira.api.UserApi;
import com.chavaillaz.client.jira.domain.Issue;
import com.chavaillaz.client.jira.domain.Issues;
import com.chavaillaz.client.jira.vertx.VertxHttpIssueApi;
import com.chavaillaz.client.jira.vertx.VertxHttpProjectApi;
import com.chavaillaz.client.jira.vertx.VertxHttpSearchApi;
import com.chavaillaz.client.jira.vertx.VertxHttpUserApi;
import io.vertx.core.Vertx;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.client.WebClientOptions;

public class VertxHttpJiraClient<I extends Issue>
extends AbstractJiraClient<WebClient, I> {
    private final Vertx vertx;

    public VertxHttpJiraClient(Vertx vertx, String jiraUrl, Class<I> issueType) {
        super(jiraUrl, issueType);
        this.vertx = vertx;
    }

    public WebClient newHttpClient() {
        return WebClient.create((Vertx)this.vertx, (WebClientOptions)VertxUtils.defaultWebClientOptions((ProxyConfiguration)this.proxy));
    }

    @Override
    public IssueApi<I> getIssueApi() {
        return (IssueApi)this.issueApi.get(() -> new VertxHttpIssueApi(this.newHttpClient(), this.baseUrl + "/rest/api/2/", this.authentication, this.issueType));
    }

    @Override
    public ProjectApi getProjectApi() {
        return (ProjectApi)this.projectApi.get(() -> new VertxHttpProjectApi(this.newHttpClient(), this.baseUrl + "/rest/api/2/", this.authentication));
    }

    @Override
    public UserApi getUserApi() {
        return (UserApi)this.userApi.get(() -> new VertxHttpUserApi(this.newHttpClient(), this.baseUrl + "/rest/api/2/", this.authentication));
    }

    @Override
    public SearchApi<Issues<I>> getSearchApi() {
        return (SearchApi)this.searchApi.get(() -> new VertxHttpSearchApi(this.newHttpClient(), this.baseUrl + "/rest/api/2/", this.authentication, this.issuesListType));
    }
}

