/*
 * Decompiled with CFR 0.152.
 */
package com.chavaillaz.client.jira.vertx;

import com.chavaillaz.client.common.security.Authentication;
import com.chavaillaz.client.jira.api.ProjectApi;
import com.chavaillaz.client.jira.domain.Components;
import com.chavaillaz.client.jira.domain.Identity;
import com.chavaillaz.client.jira.domain.Project;
import com.chavaillaz.client.jira.domain.ProjectChange;
import com.chavaillaz.client.jira.domain.Projects;
import com.chavaillaz.client.jira.domain.Roles;
import com.chavaillaz.client.jira.domain.Statuses;
import com.chavaillaz.client.jira.domain.Versions;
import com.chavaillaz.client.jira.vertx.AbstractVertxHttpClient;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.client.WebClient;
import java.util.concurrent.CompletableFuture;

public class VertxHttpProjectApi
extends AbstractVertxHttpClient
implements ProjectApi {
    public VertxHttpProjectApi(WebClient client, String baseUrl, Authentication authentication) {
        super(client, baseUrl, authentication);
    }

    @Override
    public CompletableFuture<Identity> addProject(ProjectChange project) {
        return this.handleAsync(this.requestBuilder(HttpMethod.POST, "project", new Object[0]).sendBuffer(this.body(project)), Identity.class);
    }

    @Override
    public CompletableFuture<Projects> getProjects(boolean includeArchived, String expand) {
        return this.handleAsync(this.requestBuilder(HttpMethod.GET, "project?includeArchived={0}&expand={1}", new Object[]{includeArchived, expand}).send(), Projects.class);
    }

    @Override
    public CompletableFuture<Project> getProject(String projectKey) {
        return this.handleAsync(this.requestBuilder(HttpMethod.GET, "project/{0}", new Object[]{projectKey}).send(), Project.class);
    }

    @Override
    public CompletableFuture<Versions> getProjectVersions(String projectKey) {
        return this.handleAsync(this.requestBuilder(HttpMethod.GET, "project/{0}/versions", new Object[]{projectKey}).send(), Versions.class);
    }

    @Override
    public CompletableFuture<Components> getProjectComponents(String projectKey) {
        return this.handleAsync(this.requestBuilder(HttpMethod.GET, "project/{0}/components", new Object[]{projectKey}).send(), Components.class);
    }

    @Override
    public CompletableFuture<Statuses> getProjectStatuses(String projectKey) {
        return this.handleAsync(this.requestBuilder(HttpMethod.GET, "project/{0}/statuses", new Object[]{projectKey}).send(), Statuses.class);
    }

    @Override
    public CompletableFuture<Roles> getProjectRoles(String projectKey) {
        return this.handleAsync(this.requestBuilder(HttpMethod.GET, "project/{0}/role", new Object[]{projectKey}).send(), Roles.class);
    }

    @Override
    public CompletableFuture<Project> updateProject(String projectKey, ProjectChange project) {
        return this.handleAsync(this.requestBuilder(HttpMethod.PUT, "project/{0}", new Object[]{projectKey}).sendBuffer(this.body(project)), Project.class);
    }

    @Override
    public CompletableFuture<Void> deleteProject(String projectKey) {
        return this.handleAsync(this.requestBuilder(HttpMethod.DELETE, "project/{0}", new Object[]{projectKey}).send(), Void.class);
    }
}

