/*
 * Decompiled with CFR 0.152.
 */
package com.chavaillaz.client.jira.vertx;

import com.chavaillaz.client.common.security.Authentication;
import com.chavaillaz.client.jira.api.SearchApi;
import com.chavaillaz.client.jira.api.expand.IssueExpand;
import com.chavaillaz.client.jira.domain.Filter;
import com.chavaillaz.client.jira.domain.Filters;
import com.chavaillaz.client.jira.domain.Issue;
import com.chavaillaz.client.jira.domain.Query;
import com.chavaillaz.client.jira.vertx.AbstractVertxHttpClient;
import com.fasterxml.jackson.databind.JavaType;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.client.WebClient;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public class VertxHttpSearchApi<T extends List<? extends Issue>>
extends AbstractVertxHttpClient
implements SearchApi<T> {
    protected final JavaType issuesListType;

    public VertxHttpSearchApi(WebClient client, String baseUrl, Authentication authentication, JavaType issuesListType) {
        super(client, baseUrl, authentication);
        this.issuesListType = issuesListType;
    }

    @Override
    public CompletableFuture<T> searchIssues(String jql, Integer startAt, Integer maxResults, Set<IssueExpand> expand, Set<String> fields) {
        return this.handleAsync(this.requestBuilder(HttpMethod.POST, "search", new Object[0]).sendBuffer(this.body(Query.from(jql, startAt, maxResults, expand, fields))), this.issuesListType);
    }

    @Override
    public CompletableFuture<Filter> addFilter(Filter filter) {
        return this.handleAsync(this.requestBuilder(HttpMethod.POST, "filter", new Object[0]).sendBuffer(this.body(filter)), Filter.class);
    }

    @Override
    public CompletableFuture<Filter> getFilter(String id) {
        return this.handleAsync(this.requestBuilder(HttpMethod.GET, "filter/{0}", new Object[]{id}).send(), Filter.class);
    }

    @Override
    public CompletableFuture<Filters> getFavoriteFilters() {
        return this.handleAsync(this.requestBuilder(HttpMethod.GET, "filter/favourite", new Object[0]).send(), Filters.class);
    }

    @Override
    public CompletableFuture<Filter> updateFilter(String id, Filter filter) {
        return this.handleAsync(this.requestBuilder(HttpMethod.PUT, "filter/{0}", new Object[]{id}).sendBuffer(this.body(filter)), Filter.class);
    }

    @Override
    public CompletableFuture<Void> deleteFilter(String id) {
        return this.handleAsync(this.requestBuilder(HttpMethod.DELETE, "filter/{0}", new Object[]{id}).send(), Void.class);
    }
}

