/*
 * Decompiled with CFR 0.152.
 */
package com.chavaillaz.client.jira.vertx;

import com.chavaillaz.client.common.security.Authentication;
import com.chavaillaz.client.jira.api.UserApi;
import com.chavaillaz.client.jira.domain.User;
import com.chavaillaz.client.jira.domain.Users;
import com.chavaillaz.client.jira.vertx.AbstractVertxHttpClient;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.client.WebClient;
import java.util.concurrent.CompletableFuture;

public class VertxHttpUserApi
extends AbstractVertxHttpClient
implements UserApi {
    public VertxHttpUserApi(WebClient client, String baseUrl, Authentication authentication) {
        super(client, baseUrl, authentication);
    }

    @Override
    public CompletableFuture<Users> getUsers(String search, Integer startAt, Integer maxResults, Boolean includeInactive) {
        return this.handleAsync(this.requestBuilder(HttpMethod.GET, "user/search?username={0}&startAt={1}&maxResults={2}&includeInactive={3}", new Object[]{search, startAt, maxResults, includeInactive}).send(), Users.class);
    }

    @Override
    public CompletableFuture<Users> getAssignableUsers(String search, String key, Integer startAt, Integer maxResults, Boolean includeInactive) {
        String url = key.contains("-") ? "user/assignable/search?username={0}&issueKey={1}&startAt={2}&maxResults={3}&includeInactive={4}" : "user/assignable/search?username={0}&project={1}&startAt={2}&maxResults={3}&includeInactive={4}";
        return this.handleAsync(this.requestBuilder(HttpMethod.GET, url, new Object[]{search, key, startAt, maxResults, includeInactive}).send(), Users.class);
    }

    @Override
    public CompletableFuture<User> getUser(String username) {
        return this.handleAsync(this.requestBuilder(HttpMethod.GET, "user?username={0}", new Object[]{username}).send(), User.class);
    }

    @Override
    public CompletableFuture<User> getCurrentUser() {
        return this.handleAsync(this.requestBuilder(HttpMethod.GET, "myself", new Object[0]).send(), User.class);
    }
}

