package com.checkmarx.ast.results.result;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.Value;

@Value
@JsonDeserialize()
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class VulnerabilityCVSS {

    int version;
    String attackVector;
    String availability;
    String confidentiality;
    String attackComplexity;

    public VulnerabilityCVSS(@JsonProperty("version") int version,
                             @JsonProperty("attackVector") String attackVector,
                             @JsonProperty("availability") String availability,
                             @JsonProperty("confidentiality") String confidentiality,
                             @JsonProperty("attackComplexity") String attackComplexity) {
        this.version = version;
        this.attackVector = attackVector;
        this.availability = availability;
        this.confidentiality = confidentiality;
        this.attackComplexity = attackComplexity;
    }
}
