package com.checkmarx.ast.results.result;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.Value;

import java.util.List;

@Value
@JsonDeserialize()
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class VulnerabilityDetails {

    String cweId;
    double cvssScore;
    String cveName;
    VulnerabilityCVSS cvss;
    List<String> compliances;

    public VulnerabilityDetails(@JsonProperty("cweId") String cweId,
                                @JsonProperty("cvssScore") double cvssScore,
                                @JsonProperty("cveName") String cveName,
                                @JsonProperty("cvss") VulnerabilityCVSS cvss,
                                @JsonProperty("compliances") List<String> compliances) {
        this.cweId = cweId;
        this.cvssScore = cvssScore;
        this.cveName = cveName;
        this.cvss = cvss;
        this.compliances = compliances;
    }
}
