/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.ast.project;

import com.checkmarx.ast.wrapper.CxBaseObject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.util.List;
import java.util.Map;

@JsonDeserialize
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public final class Project
extends CxBaseObject {
    private final String Name;
    private final List<String> Groups;

    @JsonCreator
    public Project(@JsonProperty(value="ID") String ID, @JsonProperty(value="Name") String Name, @JsonProperty(value="CreatedAt") String CreatedAt, @JsonProperty(value="UpdatedAt") String UpdatedAt, @JsonProperty(value="Tags") Map<String, String> Tags, @JsonProperty(value="Groups") List<String> Groups) {
        super(ID, CreatedAt, UpdatedAt, Tags);
        this.Name = Name;
        this.Groups = Groups;
    }

    public static <T> T fromLine(String line) {
        return Project.parse(line, TypeFactory.defaultInstance().constructType(Project.class));
    }

    public static <T> List<T> listFromLine(String line) {
        return (List)Project.parse(line, (JavaType)TypeFactory.defaultInstance().constructCollectionType(List.class, Project.class));
    }

    public String getName() {
        return this.Name;
    }

    public List<String> getGroups() {
        return this.Groups;
    }

    @Override
    public String toString() {
        return "Project(Name=" + this.getName() + ", Groups=" + this.getGroups() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Project)) {
            return false;
        }
        Project other = (Project)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$Name = this.getName();
        String other$Name = other.getName();
        if (this$Name == null ? other$Name != null : !this$Name.equals(other$Name)) {
            return false;
        }
        List<String> this$Groups = this.getGroups();
        List<String> other$Groups = other.getGroups();
        return !(this$Groups == null ? other$Groups != null : !((Object)this$Groups).equals(other$Groups));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Project;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $Name = this.getName();
        result = result * 59 + ($Name == null ? 43 : $Name.hashCode());
        List<String> $Groups = this.getGroups();
        result = result * 59 + ($Groups == null ? 43 : ((Object)$Groups).hashCode());
        return result;
    }
}

