/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.ast.wrapper;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

@JsonDeserialize
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public abstract class CxBaseObject {
    String ID;
    String CreatedAt;
    String UpdatedAt;
    Map<String, String> Tags;

    @JsonCreator
    public CxBaseObject(@JsonProperty(value="ID") String ID, @JsonProperty(value="CreatedAt") String createdAt, @JsonProperty(value="UpdatedAt") String updatedAt, @JsonProperty(value="Tags") Map<String, String> tags) {
        this.ID = ID;
        this.CreatedAt = createdAt;
        this.UpdatedAt = updatedAt;
        this.Tags = tags;
    }

    protected static <T> T parse(String line, JavaType type) {
        Object result = null;
        if (!StringUtils.isBlank((CharSequence)line) && CxBaseObject.isValidJSON(line)) {
            try {
                result = new ObjectMapper().readValue(line, type);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
        }
        return (T)result;
    }

    private static boolean isValidJSON(String json) {
        boolean valid = false;
        try {
            JsonParser parser = new ObjectMapper().createParser(json);
            while (parser.nextToken() != null) {
            }
            valid = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return valid;
    }

    public String getID() {
        return this.ID;
    }

    public String getCreatedAt() {
        return this.CreatedAt;
    }

    public String getUpdatedAt() {
        return this.UpdatedAt;
    }

    public Map<String, String> getTags() {
        return this.Tags;
    }

    public void setID(String ID) {
        this.ID = ID;
    }

    public void setCreatedAt(String CreatedAt) {
        this.CreatedAt = CreatedAt;
    }

    public void setUpdatedAt(String UpdatedAt) {
        this.UpdatedAt = UpdatedAt;
    }

    public void setTags(Map<String, String> Tags) {
        this.Tags = Tags;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CxBaseObject)) {
            return false;
        }
        CxBaseObject other = (CxBaseObject)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$ID = this.getID();
        String other$ID = other.getID();
        if (this$ID == null ? other$ID != null : !this$ID.equals(other$ID)) {
            return false;
        }
        String this$CreatedAt = this.getCreatedAt();
        String other$CreatedAt = other.getCreatedAt();
        if (this$CreatedAt == null ? other$CreatedAt != null : !this$CreatedAt.equals(other$CreatedAt)) {
            return false;
        }
        String this$UpdatedAt = this.getUpdatedAt();
        String other$UpdatedAt = other.getUpdatedAt();
        if (this$UpdatedAt == null ? other$UpdatedAt != null : !this$UpdatedAt.equals(other$UpdatedAt)) {
            return false;
        }
        Map<String, String> this$Tags = this.getTags();
        Map<String, String> other$Tags = other.getTags();
        return !(this$Tags == null ? other$Tags != null : !((Object)this$Tags).equals(other$Tags));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CxBaseObject;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $ID = this.getID();
        result = result * 59 + ($ID == null ? 43 : $ID.hashCode());
        String $CreatedAt = this.getCreatedAt();
        result = result * 59 + ($CreatedAt == null ? 43 : $CreatedAt.hashCode());
        String $UpdatedAt = this.getUpdatedAt();
        result = result * 59 + ($UpdatedAt == null ? 43 : $UpdatedAt.hashCode());
        Map<String, String> $Tags = this.getTags();
        result = result * 59 + ($Tags == null ? 43 : ((Object)$Tags).hashCode());
        return result;
    }

    public String toString() {
        return "CxBaseObject(ID=" + this.getID() + ", CreatedAt=" + this.getCreatedAt() + ", UpdatedAt=" + this.getUpdatedAt() + ", Tags=" + this.getTags() + ")";
    }
}

