/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.ast.wrapper;

import com.checkmarx.ast.wrapper.CxException;
import com.checkmarx.ast.wrapper.CxWrapper;
import com.checkmarx.ast.wrapper.Execution;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CxThinWrapper {
    @NonNull
    private final Logger logger;
    @NonNull
    private final String executable;

    public CxThinWrapper() throws IOException {
        this(LoggerFactory.getLogger(CxWrapper.class));
    }

    public CxThinWrapper(@NonNull Logger logger) throws IOException {
        if (logger == null) {
            throw new NullPointerException("logger is marked @NonNull but is null");
        }
        this.logger = logger;
        this.executable = Execution.getTempBinary();
        this.logger.info("using executable: " + this.executable);
    }

    public String run(@NonNull String arguments) throws CxException, IOException, InterruptedException {
        if (arguments == null) {
            throw new NullPointerException("arguments is marked @NonNull but is null");
        }
        this.logger.info("executing thin wrapper command");
        ArrayList<String> argv = new ArrayList<String>();
        argv.add(this.executable);
        argv.addAll(Arrays.asList(arguments.split(" ")));
        return Execution.executeCommand(argv, this.logger, line -> line);
    }
}

