/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.ast.wrapper;

import com.checkmarx.ast.project.Project;
import com.checkmarx.ast.results.ReportFormat;
import com.checkmarx.ast.results.Results;
import com.checkmarx.ast.scan.Scan;
import com.checkmarx.ast.wrapper.CxBaseObject;
import com.checkmarx.ast.wrapper.CxConfig;
import com.checkmarx.ast.wrapper.CxException;
import com.checkmarx.ast.wrapper.Execution;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CxWrapper {
    private static final CollectionType BRANCHES_TYPE = TypeFactory.defaultInstance().constructCollectionType(List.class, String.class);
    @NonNull
    private final CxConfig cxConfig;
    @NonNull
    private final Logger logger;
    @NonNull
    private final String executable;

    public CxWrapper(@NonNull CxConfig cxConfig) throws CxConfig.InvalidCLIConfigException, IOException {
        this(cxConfig, LoggerFactory.getLogger(CxWrapper.class));
        if (cxConfig == null) {
            throw new NullPointerException("cxConfig is marked @NonNull but is null");
        }
    }

    public CxWrapper(@NonNull CxConfig cxConfig, @NonNull Logger logger) throws CxConfig.InvalidCLIConfigException, IOException {
        if (cxConfig == null) {
            throw new NullPointerException("cxConfig is marked @NonNull but is null");
        }
        if (logger == null) {
            throw new NullPointerException("logger is marked @NonNull but is null");
        }
        cxConfig.validate();
        this.cxConfig = cxConfig;
        this.logger = logger;
        this.executable = StringUtils.isBlank((CharSequence)this.cxConfig.getPathToExecutable()) ? Execution.getTempBinary() : this.cxConfig.getPathToExecutable();
        this.logger.info("using executable: " + this.executable);
    }

    public String authValidate() throws IOException, InterruptedException, CxException {
        this.logger.info("initialized authentication validation command");
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("auth");
        arguments.add("validate");
        return Execution.executeCommand(this.withConfigArguments(arguments), this.logger, line -> line);
    }

    public Scan scanShow(@NonNull UUID scanId) throws IOException, InterruptedException, CxException {
        if (scanId == null) {
            throw new NullPointerException("scanId is marked @NonNull but is null");
        }
        this.logger.info("initialized scan retrieval for id: {}", (Object)scanId);
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("scan");
        arguments.add("show");
        arguments.add("--scan-id");
        arguments.add(scanId.toString());
        arguments.addAll(this.jsonArguments());
        return Execution.executeCommand(this.withConfigArguments(arguments), this.logger, Scan::fromLine);
    }

    public List<Scan> scanList() throws IOException, InterruptedException, CxException {
        return this.scanList("");
    }

    public List<Scan> scanList(String filter) throws IOException, InterruptedException, CxException {
        this.logger.info("initialized retrieval for scan list {}", (Object)filter);
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("scan");
        arguments.add("list");
        arguments.addAll(this.jsonArguments());
        arguments.addAll(this.filterArguments(filter));
        return Execution.executeCommand(this.withConfigArguments(arguments), this.logger, Scan::listFromLine);
    }

    public Scan scanCreate(@NonNull Map<String, String> params) throws IOException, InterruptedException, CxException {
        if (params == null) {
            throw new NullPointerException("params is marked @NonNull but is null");
        }
        return this.scanCreate(params, "");
    }

    public Scan scanCreate(@NonNull Map<String, String> params, String additionalParameters) throws IOException, InterruptedException, CxException {
        if (params == null) {
            throw new NullPointerException("params is marked @NonNull but is null");
        }
        this.logger.info("initialized scan create command");
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("scan");
        arguments.add("create");
        arguments.addAll(this.jsonArguments());
        for (Map.Entry<String, String> param : params.entrySet()) {
            arguments.add(param.getKey());
            arguments.add(param.getValue());
        }
        arguments.addAll(CxConfig.parseAdditionalParameters(additionalParameters));
        return Execution.executeCommand(this.withConfigArguments(arguments), this.logger, Scan::fromLine);
    }

    public Project projectShow(@NonNull UUID projectId) throws IOException, InterruptedException, CxException {
        if (projectId == null) {
            throw new NullPointerException("projectId is marked @NonNull but is null");
        }
        this.logger.info("initialized project retrieval for id: {}", (Object)projectId);
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("project");
        arguments.add("show");
        arguments.add("--project-id");
        arguments.add(projectId.toString());
        arguments.addAll(this.jsonArguments());
        return Execution.executeCommand(this.withConfigArguments(arguments), this.logger, Project::fromLine);
    }

    public List<Project> projectList() throws IOException, InterruptedException, CxException {
        return this.projectList("");
    }

    public List<Project> projectList(String filter) throws IOException, InterruptedException, CxException {
        this.logger.info("initialized retrieval for project list {}", (Object)filter);
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("project");
        arguments.add("list");
        arguments.addAll(this.filterArguments(filter));
        arguments.addAll(this.jsonArguments());
        return Execution.executeCommand(this.withConfigArguments(arguments), this.logger, Project::listFromLine);
    }

    public List<String> projectBranches(@NonNull UUID projectId, String filter) throws CxException, IOException, InterruptedException {
        if (projectId == null) {
            throw new NullPointerException("projectId is marked @NonNull but is null");
        }
        this.logger.info("initialized retrieval for project branches {}", (Object)filter);
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("project");
        arguments.add("branches");
        arguments.add("--project-id");
        arguments.add(projectId.toString());
        arguments.addAll(this.filterArguments(filter));
        return Execution.executeCommand(this.withConfigArguments(arguments), this.logger, line -> (List)CxBaseObject.parse(line, (JavaType)BRANCHES_TYPE));
    }

    public Results results(@NonNull UUID scanId) throws IOException, InterruptedException, CxException {
        if (scanId == null) {
            throw new NullPointerException("scanId is marked @NonNull but is null");
        }
        return (Results)new ObjectMapper().readerFor(Results.class).readValue(this.results(scanId, ReportFormat.json));
    }

    public String results(@NonNull UUID scanId, ReportFormat reportFormat) throws IOException, InterruptedException, CxException {
        if (scanId == null) {
            throw new NullPointerException("scanId is marked @NonNull but is null");
        }
        this.logger.info("initialized results command {}", (Object)reportFormat);
        String tempDir = Files.createTempDirectory("cx", new FileAttribute[0]).toAbsolutePath().toString();
        String fileName = Long.toString(System.nanoTime());
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("result");
        arguments.add("--scan-id");
        arguments.add(scanId.toString());
        arguments.add("--report-format");
        arguments.add(reportFormat.toString());
        arguments.add("--output-name");
        arguments.add(fileName);
        arguments.add("--output-path");
        arguments.add(tempDir);
        return Execution.executeCommand(this.withConfigArguments(arguments), this.logger, tempDir, fileName + reportFormat.getExtension());
    }

    private List<String> withConfigArguments(List<String> commands) {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(this.executable);
        arguments.addAll(commands);
        arguments.addAll(this.cxConfig.toArguments());
        return arguments;
    }

    private List<String> jsonArguments() {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("--format");
        arguments.add("json");
        return arguments;
    }

    private List<String> filterArguments(String filter) {
        ArrayList<String> arguments = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            arguments.add("--filter");
            arguments.add(filter);
        }
        return arguments;
    }
}

