package com.checkmarx.ast.results.result;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.Value;

@Value
@JsonDeserialize()
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class VulnerabilityCVSS {

    int version;
    String attackVector;
    String availability;
    String confidentiality;
    String attackComplexity;
    String integrityImpact;
    String scope;
    String privilegesRequired;
    String userInteraction;


    public VulnerabilityCVSS(@JsonProperty("version") int version,
                             @JsonProperty("attackVector") String attackVector,
                             @JsonProperty("availability") String availability,
                             @JsonProperty("confidentiality") String confidentiality,
                             @JsonProperty("attackComplexity") String attackComplexity,
                             @JsonProperty("integrityImpact") String integrityImpact,
                             @JsonProperty("scope") String scope,
                             @JsonProperty("privilegesRequired") String privilegesRequired,
                             @JsonProperty("userInteraction") String userInteraction) {
        this.version = version;
        this.attackVector = attackVector;
        this.availability = availability;
        this.confidentiality = confidentiality;
        this.attackComplexity = attackComplexity;
        this.integrityImpact = integrityImpact;
        this.scope = scope;
        this.privilegesRequired = privilegesRequired;
        this.userInteraction = userInteraction;
    }
}
