/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.ast.learnMore;

import com.checkmarx.ast.learnMore.Sample;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

@JsonDeserialize
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public final class LearnMore {
    private final String queryId;
    private final String queryName;
    private final String queryDescriptionId;
    private final String resultDescription;
    private final String risk;
    private final String cause;
    private final String generalRecommendations;
    private final List<Sample> samples;

    @JsonCreator
    public LearnMore(@JsonProperty(value="queryID") String queryId, @JsonProperty(value="queryName") String queryName, @JsonProperty(value="queryDescriptionID") String queryDescriptionId, @JsonProperty(value="resultDescription") String resultDescription, @JsonProperty(value="risk") String risk, @JsonProperty(value="cause") String cause, @JsonProperty(value="generalRecommendations") String generalRecommendations, @JsonProperty(value="samples") List<Sample> samples) {
        this.queryId = queryId;
        this.queryName = queryName;
        this.queryDescriptionId = queryDescriptionId;
        this.resultDescription = resultDescription;
        this.risk = risk;
        this.cause = cause;
        this.generalRecommendations = generalRecommendations;
        this.samples = samples;
    }

    public static <T> List<T> listFromLine(String line) {
        return (List)LearnMore.parse(line, (JavaType)TypeFactory.defaultInstance().constructCollectionType(List.class, LearnMore.class));
    }

    public static <T> T fromLine(String line) {
        return LearnMore.parse(line, TypeFactory.defaultInstance().constructType(LearnMore.class));
    }

    private static <T> T parse(String line, JavaType type) {
        Object result = null;
        try {
            if (!StringUtils.isBlank((CharSequence)line) && LearnMore.isValidJSON(line)) {
                result = new ObjectMapper().readValue(line, type);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return (T)result;
    }

    private static boolean isValidJSON(String json) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.readTree(json);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public String getQueryId() {
        return this.queryId;
    }

    public String getQueryName() {
        return this.queryName;
    }

    public String getQueryDescriptionId() {
        return this.queryDescriptionId;
    }

    public String getResultDescription() {
        return this.resultDescription;
    }

    public String getRisk() {
        return this.risk;
    }

    public String getCause() {
        return this.cause;
    }

    public String getGeneralRecommendations() {
        return this.generalRecommendations;
    }

    public List<Sample> getSamples() {
        return this.samples;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LearnMore)) {
            return false;
        }
        LearnMore other = (LearnMore)o;
        String this$queryId = this.getQueryId();
        String other$queryId = other.getQueryId();
        if (this$queryId == null ? other$queryId != null : !this$queryId.equals(other$queryId)) {
            return false;
        }
        String this$queryName = this.getQueryName();
        String other$queryName = other.getQueryName();
        if (this$queryName == null ? other$queryName != null : !this$queryName.equals(other$queryName)) {
            return false;
        }
        String this$queryDescriptionId = this.getQueryDescriptionId();
        String other$queryDescriptionId = other.getQueryDescriptionId();
        if (this$queryDescriptionId == null ? other$queryDescriptionId != null : !this$queryDescriptionId.equals(other$queryDescriptionId)) {
            return false;
        }
        String this$resultDescription = this.getResultDescription();
        String other$resultDescription = other.getResultDescription();
        if (this$resultDescription == null ? other$resultDescription != null : !this$resultDescription.equals(other$resultDescription)) {
            return false;
        }
        String this$risk = this.getRisk();
        String other$risk = other.getRisk();
        if (this$risk == null ? other$risk != null : !this$risk.equals(other$risk)) {
            return false;
        }
        String this$cause = this.getCause();
        String other$cause = other.getCause();
        if (this$cause == null ? other$cause != null : !this$cause.equals(other$cause)) {
            return false;
        }
        String this$generalRecommendations = this.getGeneralRecommendations();
        String other$generalRecommendations = other.getGeneralRecommendations();
        if (this$generalRecommendations == null ? other$generalRecommendations != null : !this$generalRecommendations.equals(other$generalRecommendations)) {
            return false;
        }
        List<Sample> this$samples = this.getSamples();
        List<Sample> other$samples = other.getSamples();
        return !(this$samples == null ? other$samples != null : !((Object)this$samples).equals(other$samples));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $queryId = this.getQueryId();
        result = result * 59 + ($queryId == null ? 43 : $queryId.hashCode());
        String $queryName = this.getQueryName();
        result = result * 59 + ($queryName == null ? 43 : $queryName.hashCode());
        String $queryDescriptionId = this.getQueryDescriptionId();
        result = result * 59 + ($queryDescriptionId == null ? 43 : $queryDescriptionId.hashCode());
        String $resultDescription = this.getResultDescription();
        result = result * 59 + ($resultDescription == null ? 43 : $resultDescription.hashCode());
        String $risk = this.getRisk();
        result = result * 59 + ($risk == null ? 43 : $risk.hashCode());
        String $cause = this.getCause();
        result = result * 59 + ($cause == null ? 43 : $cause.hashCode());
        String $generalRecommendations = this.getGeneralRecommendations();
        result = result * 59 + ($generalRecommendations == null ? 43 : $generalRecommendations.hashCode());
        List<Sample> $samples = this.getSamples();
        result = result * 59 + ($samples == null ? 43 : ((Object)$samples).hashCode());
        return result;
    }

    public String toString() {
        return "LearnMore(queryId=" + this.getQueryId() + ", queryName=" + this.getQueryName() + ", queryDescriptionId=" + this.getQueryDescriptionId() + ", resultDescription=" + this.getResultDescription() + ", risk=" + this.getRisk() + ", cause=" + this.getCause() + ", generalRecommendations=" + this.getGeneralRecommendations() + ", samples=" + this.getSamples() + ")";
    }
}

