/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.ast.scan;

import com.checkmarx.ast.wrapper.CxBaseObject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.util.List;
import java.util.Map;

@JsonDeserialize
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public final class Scan
extends CxBaseObject {
    private final String projectId;
    private final String status;
    private final String initiator;
    private final String origin;
    private final String branch;

    @JsonCreator
    public Scan(@JsonProperty(value="ID") String id, @JsonProperty(value="ProjectID") String projectId, @JsonProperty(value="Status") String status, @JsonProperty(value="CreatedAt") String createdAt, @JsonProperty(value="UpdatedAt") String updatedAt, @JsonProperty(value="Tags") Map<String, String> tags, @JsonProperty(value="Initiator") String initiator, @JsonProperty(value="Origin") String origin, @JsonProperty(value="Branch") String branch) {
        super(id, createdAt, updatedAt, tags);
        this.projectId = projectId;
        this.status = status;
        this.initiator = initiator;
        this.origin = origin;
        this.branch = branch;
    }

    public static <T> T fromLine(String line) {
        return Scan.parse(line, TypeFactory.defaultInstance().constructType(Scan.class));
    }

    public static <T> List<T> listFromLine(String line) {
        return (List)Scan.parse(line, (JavaType)TypeFactory.defaultInstance().constructCollectionType(List.class, Scan.class));
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getStatus() {
        return this.status;
    }

    public String getInitiator() {
        return this.initiator;
    }

    public String getOrigin() {
        return this.origin;
    }

    public String getBranch() {
        return this.branch;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Scan)) {
            return false;
        }
        Scan other = (Scan)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$projectId = this.getProjectId();
        String other$projectId = other.getProjectId();
        if (this$projectId == null ? other$projectId != null : !this$projectId.equals(other$projectId)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$initiator = this.getInitiator();
        String other$initiator = other.getInitiator();
        if (this$initiator == null ? other$initiator != null : !this$initiator.equals(other$initiator)) {
            return false;
        }
        String this$origin = this.getOrigin();
        String other$origin = other.getOrigin();
        if (this$origin == null ? other$origin != null : !this$origin.equals(other$origin)) {
            return false;
        }
        String this$branch = this.getBranch();
        String other$branch = other.getBranch();
        return !(this$branch == null ? other$branch != null : !this$branch.equals(other$branch));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Scan;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $projectId = this.getProjectId();
        result = result * 59 + ($projectId == null ? 43 : $projectId.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $initiator = this.getInitiator();
        result = result * 59 + ($initiator == null ? 43 : $initiator.hashCode());
        String $origin = this.getOrigin();
        result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
        String $branch = this.getBranch();
        result = result * 59 + ($branch == null ? 43 : $branch.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "Scan(super=" + super.toString() + ", projectId=" + this.getProjectId() + ", status=" + this.getStatus() + ", initiator=" + this.getInitiator() + ", origin=" + this.getOrigin() + ", branch=" + this.getBranch() + ")";
    }
}

