/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.ast.project;

import com.checkmarx.ast.wrapper.CxBaseObject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.util.List;
import java.util.Map;

@JsonDeserialize
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public final class Project
extends CxBaseObject {
    private final String name;
    private final List<String> groups;

    @JsonCreator
    public Project(@JsonProperty(value="ID") String id, @JsonProperty(value="Name") String name, @JsonProperty(value="CreatedAt") String createdAt, @JsonProperty(value="UpdatedAt") String updatedAt, @JsonProperty(value="Tags") Map<String, String> tags, @JsonProperty(value="Groups") List<String> groups) {
        super(id, createdAt, updatedAt, tags);
        this.name = name;
        this.groups = groups;
    }

    public static <T> T fromLine(String line) {
        return Project.parse(line, TypeFactory.defaultInstance().constructType(Project.class));
    }

    public static <T> List<T> listFromLine(String line) {
        return (List)Project.parse(line, (JavaType)TypeFactory.defaultInstance().constructCollectionType(List.class, Project.class));
    }

    public String getName() {
        return this.name;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    @Override
    public String toString() {
        return "Project(name=" + this.getName() + ", groups=" + this.getGroups() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Project)) {
            return false;
        }
        Project other = (Project)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<String> this$groups = this.getGroups();
        List<String> other$groups = other.getGroups();
        return !(this$groups == null ? other$groups != null : !((Object)this$groups).equals(other$groups));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Project;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<String> $groups = this.getGroups();
        result = result * 59 + ($groups == null ? 43 : ((Object)$groups).hashCode());
        return result;
    }
}

