/*
 * Decompiled with CFR 0.152.
 */
package com.cx.restclient;

import com.cx.restclient.common.Waiter;
import com.cx.restclient.configuration.CxScanConfig;
import com.cx.restclient.cxArm.dto.CxProviders;
import com.cx.restclient.cxArm.utils.CxARMUtils;
import com.cx.restclient.dto.Status;
import com.cx.restclient.exception.CxClientException;
import com.cx.restclient.httpClient.CxHttpClient;
import com.cx.restclient.httpClient.utils.HttpClientHelper;
import com.cx.restclient.osa.dto.CVE;
import com.cx.restclient.osa.dto.CreateOSAScanRequest;
import com.cx.restclient.osa.dto.CreateOSAScanResponse;
import com.cx.restclient.osa.dto.Library;
import com.cx.restclient.osa.dto.OSAResults;
import com.cx.restclient.osa.dto.OSAScanStatus;
import com.cx.restclient.osa.dto.OSAScanStatusEnum;
import com.cx.restclient.osa.dto.OSASummaryResults;
import com.cx.restclient.osa.utils.OSAUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Properties;
import org.apache.http.HttpEntity;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.whitesource.fs.ComponentScan;

class CxOSAClient {
    private CxHttpClient httpClient;
    private Logger log;
    private CxScanConfig config;
    private Waiter<OSAScanStatus> osaWaiter = new Waiter<OSAScanStatus>("CxOSA scan", 20){

        @Override
        public OSAScanStatus getStatus(String id) throws CxClientException, IOException {
            return CxOSAClient.this.getOSAScanStatus(id);
        }

        @Override
        public void printProgress(OSAScanStatus scanStatus) {
            CxOSAClient.this.printOSAProgress(scanStatus, this.getStartTimeSec());
        }

        @Override
        public OSAScanStatus resolveStatus(OSAScanStatus scanStatus) throws CxClientException {
            return CxOSAClient.this.resolveOSAStatus(scanStatus);
        }
    };

    public CxOSAClient(CxHttpClient client, Logger log, CxScanConfig config) {
        this.log = log;
        this.httpClient = client;
        this.config = config;
    }

    public String createOSAScan(long projectId) throws IOException, CxClientException {
        this.log.info("----------------------------------- Create CxOSA Scan:------------------------------------");
        this.log.info("Creating OSA scan");
        String osaDependenciesJson = this.config.getOsaDependenciesJson();
        if (osaDependenciesJson == null) {
            try {
                osaDependenciesJson = this.resolveOSADependencies();
            }
            catch (Exception e) {
                throw new CxClientException("Failed to resolve dependencies for OSA scan: " + e.getMessage(), e);
            }
        }
        return this.sendOSAScan(osaDependenciesJson, projectId);
    }

    private String resolveOSADependencies() throws JsonProcessingException {
        this.log.info("Scanning for CxOSA compatible files");
        Properties scannerProperties = this.config.getOsaFsaConfig();
        if (scannerProperties == null) {
            scannerProperties = OSAUtils.generateOSAScanConfiguration(this.config.getOsaFolderExclusions(), this.config.getOsaFilterPattern(), this.config.getOsaArchiveIncludePatterns(), this.config.getSourceDir(), this.config.getOsaRunInstall(), this.log);
        }
        ObjectMapper mapper = new ObjectMapper();
        this.log.info("Scanner properties: " + mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)scannerProperties.toString()));
        ComponentScan componentScan = new ComponentScan(scannerProperties);
        String osaDependenciesJson = componentScan.scan();
        OSAUtils.writeToOsaListToFile(this.config.getReportsDir(), osaDependenciesJson, this.log);
        return osaDependenciesJson;
    }

    public OSAResults getOSAResults(String scanId, long projectId) throws CxClientException, InterruptedException, IOException {
        this.log.info("-------------------------------------Get CxOSA Results:-----------------------------------");
        this.log.info("Waiting for OSA scan to finish");
        OSAScanStatus osaScanStatus = this.osaWaiter.waitForTaskToFinish(scanId, this.config.getOsaScanTimeoutInMinutes(), this.log);
        this.log.info("OSA scan finished successfully. Retrieving OSA scan results");
        this.log.info("Creating OSA reports");
        OSAResults osaResults = this.retrieveOSAResults(scanId, osaScanStatus, projectId);
        if (this.config.getEnablePolicyViolations()) {
            this.resolveOSAViolation(osaResults, projectId);
        }
        OSAUtils.printOSAResultsToConsole(osaResults, this.config.getEnablePolicyViolations(), this.log);
        if (this.config.getReportsDir() != null) {
            OSAUtils.writeJsonToFile("CxOSASummary", osaResults.getResults(), this.config.getReportsDir(), this.log);
            OSAUtils.writeJsonToFile("CxOSALibraries", osaResults.getOsaLibraries(), this.config.getReportsDir(), this.log);
            OSAUtils.writeJsonToFile("CxOSAVulnerabilities", osaResults.getOsaVulnerabilities(), this.config.getReportsDir(), this.log);
        }
        return osaResults;
    }

    private OSAResults retrieveOSAResults(String scanId, OSAScanStatus osaScanStatus, long projectId) throws CxClientException, IOException {
        OSASummaryResults osaSummaryResults = this.getOSAScanSummaryResults(scanId);
        List<Library> osaLibraries = this.getOSALibraries(scanId);
        List<CVE> osaVulnerabilities = this.getOSAVulnerabilities(scanId);
        OSAResults results = new OSAResults();
        results.setOsaScanId(scanId);
        results.setResults(osaSummaryResults, osaLibraries, osaVulnerabilities, osaScanStatus, this.config.getUrl(), projectId);
        return results;
    }

    private void resolveOSAViolation(OSAResults osaResults, long projectId) {
        try {
            CxARMUtils.getProjectViolatedPolicies(this.httpClient, this.config.getCxARMUrl(), projectId, CxProviders.OPEN_SOURCE.value()).forEach(osaResults::addPolicy);
        }
        catch (Exception ex) {
            this.log.error("CxARM is not available. Policy violations for OSA cannot be calculated: " + ex.getMessage());
        }
    }

    public OSAResults getLatestOSAResults(long projectId) throws CxClientException, IOException, InterruptedException {
        this.log.info("----------------------------------Get CxOSA Last Results:--------------------------------");
        List<OSAScanStatus> scanList = this.getOSALastOSAStatus(projectId);
        for (OSAScanStatus s : scanList) {
            if (!Status.SUCCEEDED.value().equals(s.getState().getName())) continue;
            return this.retrieveOSAResults(s.getId(), s, projectId);
        }
        return new OSAResults();
    }

    private String sendOSAScan(String osaDependenciesJson, long projectId) throws CxClientException, IOException {
        this.log.info("Sending OSA scan request");
        CreateOSAScanResponse osaScan = this.sendOSARequest(projectId, osaDependenciesJson);
        String summaryLink = OSAUtils.composeProjectOSASummaryLink(this.config.getUrl(), projectId);
        this.log.info("OSA scan created successfully. Link to project state: " + summaryLink);
        return osaScan.getScanId();
    }

    private CreateOSAScanResponse sendOSARequest(long projectId, String osaDependenciesJson) throws IOException, CxClientException {
        CreateOSAScanRequest req = new CreateOSAScanRequest(projectId, osaDependenciesJson);
        StringEntity entity = new StringEntity(HttpClientHelper.convertToJson(req), StandardCharsets.UTF_8);
        return this.httpClient.postRequest("osa/inventory", "application/json;v=1.0", (HttpEntity)entity, CreateOSAScanResponse.class, 201, "create OSA scan");
    }

    private OSASummaryResults getOSAScanSummaryResults(String scanId) throws IOException, CxClientException {
        String relativePath = "osa/reports?scanId=" + scanId;
        return this.httpClient.getRequest(relativePath, "application/json;v=1.0", OSASummaryResults.class, 200, "OSA scan summary results", false);
    }

    private List<OSAScanStatus> getOSALastOSAStatus(long projectId) throws IOException, CxClientException {
        return (List)((Object)this.httpClient.getRequest("osa/scans?projectId=" + projectId, "application/json;v=1.0", OSAScanStatus.class, 200, " last OSA scan ID", true));
    }

    private List<Library> getOSALibraries(String scanId) throws IOException, CxClientException {
        String relPath = "/osa/libraries?scanId=" + scanId + "&itemsPerPage=" + 1000000L;
        return (List)((Object)this.httpClient.getRequest(relPath, "application/json;v=1.0", Library.class, 200, "OSA libraries", true));
    }

    private List<CVE> getOSAVulnerabilities(String scanId) throws CxClientException, IOException {
        String relPath = "/osa/vulnerabilities?scanId=" + scanId + "&itemsPerPage=" + 1000000L;
        return (List)((Object)this.httpClient.getRequest(relPath, "application/json;v=1.0", CVE.class, 200, "OSA vulnerabilities", true));
    }

    private OSAScanStatus getOSAScanStatus(String scanId) throws CxClientException, IOException {
        String relPath = "osa/scans/{scanId}".replace("{scanId}", scanId);
        OSAScanStatus scanStatus = this.httpClient.getRequest(relPath, "application/json;v=1.0", OSAScanStatus.class, 200, "OSA scan status", false);
        int stateId = scanStatus.getState().getId();
        if (OSAScanStatusEnum.SUCCEEDED.getNum() == stateId) {
            scanStatus.setBaseStatus(Status.SUCCEEDED);
        } else if (OSAScanStatusEnum.IN_PROGRESS.getNum() == stateId || OSAScanStatusEnum.NOT_STARTED.getNum() == stateId) {
            scanStatus.setBaseStatus(Status.IN_PROGRESS);
        } else {
            scanStatus.setBaseStatus(Status.FAILED);
        }
        return scanStatus;
    }

    private void printOSAProgress(OSAScanStatus scanStatus, long startTime) {
        long elapsedSec = System.currentTimeMillis() / 1000L - startTime;
        long hours = elapsedSec / 3600L;
        long minutes = elapsedSec % 3600L / 60L;
        long seconds = elapsedSec % 60L;
        String hoursStr = hours < 10L ? "0" + Long.toString(hours) : Long.toString(hours);
        String minutesStr = minutes < 10L ? "0" + Long.toString(minutes) : Long.toString(minutes);
        String secondsStr = seconds < 10L ? "0" + Long.toString(seconds) : Long.toString(seconds);
        this.log.info("Waiting for OSA scan results. Elapsed time: " + hoursStr + ":" + minutesStr + ":" + secondsStr + ". Status: " + scanStatus.getState().getName());
    }

    private OSAScanStatus resolveOSAStatus(OSAScanStatus scanStatus) throws CxClientException {
        if (scanStatus == null || Status.FAILED == scanStatus.getBaseStatus()) {
            String failedMsg = scanStatus.getState() == null ? "" : "status [" + scanStatus.getState().getName() + "]. Reason: " + scanStatus.getState().getFailureReason();
            throw new CxClientException("OSA scan cannot be completed. " + failedMsg);
        }
        if (Status.SUCCEEDED == scanStatus.getBaseStatus()) {
            this.log.info("OSA scan finished.");
            return scanStatus;
        }
        return scanStatus;
    }
}

