/*
 * Decompiled with CFR 0.152.
 */
package com.cx.restclient;

import com.cx.restclient.common.Waiter;
import com.cx.restclient.configuration.CxScanConfig;
import com.cx.restclient.cxArm.dto.CxProviders;
import com.cx.restclient.cxArm.utils.CxARMUtils;
import com.cx.restclient.dto.RemoteSourceRequest;
import com.cx.restclient.dto.RemoteSourceTypes;
import com.cx.restclient.dto.Status;
import com.cx.restclient.exception.CxClientException;
import com.cx.restclient.httpClient.CxHttpClient;
import com.cx.restclient.httpClient.utils.HttpClientHelper;
import com.cx.restclient.sast.dto.CreateReportRequest;
import com.cx.restclient.sast.dto.CreateReportResponse;
import com.cx.restclient.sast.dto.CreateScanRequest;
import com.cx.restclient.sast.dto.CurrentStatus;
import com.cx.restclient.sast.dto.CxARMStatus;
import com.cx.restclient.sast.dto.CxARMStatusEnum;
import com.cx.restclient.sast.dto.CxID;
import com.cx.restclient.sast.dto.CxXMLResults;
import com.cx.restclient.sast.dto.LastScanResponse;
import com.cx.restclient.sast.dto.QueueStatus;
import com.cx.restclient.sast.dto.ReportStatus;
import com.cx.restclient.sast.dto.ReportStatusEnum;
import com.cx.restclient.sast.dto.ReportType;
import com.cx.restclient.sast.dto.ResponseQueueScanStatus;
import com.cx.restclient.sast.dto.SASTResults;
import com.cx.restclient.sast.dto.SASTStatisticsResponse;
import com.cx.restclient.sast.dto.ScanSettingRequest;
import com.cx.restclient.sast.dto.ScanSettingResponse;
import com.cx.restclient.sast.dto.UpdateScanStatusRequest;
import com.cx.restclient.sast.utils.SASTUtils;
import com.cx.restclient.sast.utils.zip.CxZipUtils;
import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.json.JSONObject;
import org.slf4j.Logger;

class CxSASTClient {
    public static final String JENKINS = "jenkins";
    private Logger log;
    private CxHttpClient httpClient;
    private CxScanConfig config;
    private int reportTimeoutSec = 5000;
    private int cxARMTimeoutSec = 1000;
    private Waiter<ResponseQueueScanStatus> sastWaiter = new Waiter<ResponseQueueScanStatus>("CxSAST scan", 20){

        @Override
        public ResponseQueueScanStatus getStatus(String id) throws CxClientException, IOException {
            return CxSASTClient.this.getSASTScanStatus(id);
        }

        @Override
        public void printProgress(ResponseQueueScanStatus scanStatus) {
            CxSASTClient.this.printSASTProgress(scanStatus, this.getStartTimeSec());
        }

        @Override
        public ResponseQueueScanStatus resolveStatus(ResponseQueueScanStatus scanStatus) throws CxClientException {
            return CxSASTClient.this.resolveSASTStatus(scanStatus);
        }
    };
    private Waiter<ReportStatus> reportWaiter = new Waiter<ReportStatus>("Scan report", 10){

        @Override
        public ReportStatus getStatus(String id) throws CxClientException, IOException {
            return CxSASTClient.this.getReportStatus(id);
        }

        @Override
        public void printProgress(ReportStatus reportStatus) {
            CxSASTClient.this.printReportProgress(reportStatus, this.getStartTimeSec());
        }

        @Override
        public ReportStatus resolveStatus(ReportStatus reportStatus) throws CxClientException {
            return CxSASTClient.this.resolveReportStatus(reportStatus);
        }
    };
    private Waiter<CxARMStatus> cxARMWaiter = new Waiter<CxARMStatus>("CxARM policy violations", 20){

        @Override
        public CxARMStatus getStatus(String id) throws CxClientException, IOException {
            return CxSASTClient.this.getCxARMStatus(id);
        }

        @Override
        public void printProgress(CxARMStatus cxARMStatus) {
            CxSASTClient.this.printCxARMProgress(cxARMStatus, this.getStartTimeSec());
        }

        @Override
        public CxARMStatus resolveStatus(CxARMStatus cxARMStatus) throws CxClientException {
            return CxSASTClient.this.resolveCxARMStatus(cxARMStatus);
        }
    };

    CxSASTClient(CxHttpClient client, Logger log, CxScanConfig config) {
        this.log = log;
        this.httpClient = client;
        this.config = config;
    }

    long createSASTScan(long projectId) throws IOException, CxClientException {
        this.log.info("-----------------------------------Create CxSAST Scan:------------------------------------");
        if (this.config.isAvoidDuplicateProjectScans() != null && this.config.isAvoidDuplicateProjectScans().booleanValue() && this.projectHasQueuedScans(projectId)) {
            throw new CxClientException("\nAvoid duplicate project scans in queue\n");
        }
        if (this.config.getRemoteType() == null) {
            return this.createLocalSASTScan(projectId);
        }
        return this.createRemoteSourceScan(projectId);
    }

    private long createLocalSASTScan(long projectId) throws IOException, CxClientException {
        ScanSettingResponse scanSettingResponse = this.getScanSetting(projectId);
        ScanSettingRequest scanSettingRequest = new ScanSettingRequest();
        scanSettingRequest.setEngineConfigurationId(scanSettingResponse.getEngineConfiguration().getId());
        scanSettingRequest.setProjectId(projectId);
        scanSettingRequest.setPresetId(this.config.getPresetId().intValue());
        if (this.config.getEngineConfigurationId() != null) {
            scanSettingRequest.setEngineConfigurationId(this.config.getEngineConfigurationId().intValue());
        }
        this.defineScanSetting(scanSettingRequest);
        if (this.config.getZipFile() == null) {
            this.log.info("Zipping sources");
            File zipTempFile = CxZipUtils.zipWorkspaceFolder(this.config, 0x80000000L, this.log);
            this.uploadZipFile(zipTempFile, projectId);
            SASTUtils.deleteTempZipFile(zipTempFile, this.log);
        } else {
            this.uploadZipFile(this.config.getZipFile(), projectId);
        }
        this.log.info("Uploading zip file");
        CreateScanRequest scanRequest = new CreateScanRequest(projectId, this.config.getIncremental(), this.config.getPublic(), this.config.getForceScan(), this.config.getScanComment() == null ? "" : this.config.getScanComment());
        this.log.info("Sending SAST scan request");
        CxID createScanResponse = this.createScan(scanRequest);
        this.log.info(String.format("SAST Scan created successfully. Link to project state: " + this.config.getUrl() + "/CxWebClient/portal#/projectState/%d/Summary", projectId));
        return createScanResponse.getId();
    }

    private long createRemoteSourceScan(long projectId) throws IOException, CxClientException {
        StringEntity entity;
        RemoteSourceRequest req = new RemoteSourceRequest(this.config);
        RemoteSourceTypes type = req.getType();
        switch (type) {
            case SVN: 
            case TFS: {
                MultipartEntityBuilder builder = MultipartEntityBuilder.create();
                builder.addBinaryBody("privateKey", req.getPrivateKey(), ContentType.APPLICATION_JSON, null);
                builder.addTextBody("absoluteUrl", req.getUrl(), ContentType.APPLICATION_JSON);
                builder.addTextBody("port", String.valueOf(req.getPort()), ContentType.APPLICATION_JSON);
                builder.addTextBody("paths", StringUtils.join((Object[])req.getPaths(), (String)";"), ContentType.APPLICATION_JSON);
                entity = builder.build();
                break;
            }
            case PERFORCE: {
                if (this.config.getPreforceMode() != null) {
                    req.setBrowseMode("Workspace");
                } else {
                    req.setBrowseMode("Depot");
                }
                entity = new StringEntity(HttpClientHelper.convertToJson(req), StandardCharsets.UTF_8);
                break;
            }
            case SHARED: {
                entity = new StringEntity(new Gson().toJson((Object)req), StandardCharsets.UTF_8);
                break;
            }
            case GIT: {
                if (req.getPrivateKey().length < 1) {
                    HashMap<String, String> content = new HashMap<String, String>();
                    content.put("url", this.config.getRemoteSrcUrl());
                    content.put("branch", this.config.getRemoteSrcBranch());
                    entity = new StringEntity(new JSONObject(content).toString(), StandardCharsets.UTF_8);
                    break;
                }
                MultipartEntityBuilder builder = MultipartEntityBuilder.create();
                builder.addTextBody("url", req.getUrl(), ContentType.APPLICATION_JSON);
                builder.addTextBody("branch", this.config.getRemoteSrcBranch(), ContentType.APPLICATION_JSON);
                builder.addBinaryBody("privateKey", req.getPrivateKey(), ContentType.MULTIPART_FORM_DATA, null);
                entity = builder.build();
                break;
            }
            default: {
                this.log.error("todo");
                entity = new StringEntity("", StandardCharsets.UTF_8);
            }
        }
        return this.createRemoteSourceScan(projectId, (HttpEntity)entity, type.value()).getId();
    }

    public SASTResults waitForSASTResults(long scanId, long projectId) throws InterruptedException, IOException, CxClientException {
        this.log.info("------------------------------------Get CxSAST Results:-----------------------------------");
        this.log.info("Waiting for CxSAST scan to finish.");
        this.sastWaiter.waitForTaskToFinish(Long.toString(scanId), this.config.getSastScanTimeoutInMinutes() * 60, this.log);
        this.log.info("Retrieving SAST scan results");
        SASTResults sastResults = this.retrieveSASTResults(scanId, projectId);
        if (this.config.getEnablePolicyViolations()) {
            this.resolveSASTViolation(sastResults, projectId);
        }
        SASTUtils.printSASTResultsToConsole(sastResults, this.config.getEnablePolicyViolations(), this.log);
        if (this.config.getGeneratePDFReport().booleanValue()) {
            this.log.info("Generating PDF report");
            byte[] pdfReport = this.getScanReport(sastResults.getScanId(), ReportType.PDF, "application/pdf;v=1.0");
            sastResults.setPDFReport(pdfReport);
            if (this.config.getReportsDir() != null) {
                String now = new SimpleDateFormat("dd_MM_yyyy-HH_mm_ss").format(new Date());
                String pdfFileName = "CxSASTReport_" + now + ".pdf";
                pdfFileName = SASTUtils.writePDFReport(pdfReport, this.config.getReportsDir(), pdfFileName, this.log);
                sastResults.setPdfFileName(pdfFileName);
            }
        }
        return sastResults;
    }

    private void resolveSASTViolation(SASTResults sastResults, long projectId) {
        try {
            this.cxARMWaiter.waitForTaskToFinish(Long.toString(projectId), this.cxARMTimeoutSec, this.log);
            CxARMUtils.getProjectViolatedPolicies(this.httpClient, this.config.getCxARMUrl(), projectId, CxProviders.SAST.value()).forEach(sastResults::addPolicy);
        }
        catch (Exception ex) {
            this.log.error("CxARM is not available. Policy violations for SAST cannot be calculated: " + ex.getMessage());
        }
    }

    private SASTResults retrieveSASTResults(long scanId, long projectId) throws CxClientException, IOException, InterruptedException {
        SASTResults sastResults = new SASTResults();
        SASTStatisticsResponse statisticsResults = this.getScanStatistics(scanId);
        sastResults.setResults(scanId, statisticsResults, this.config.getUrl(), projectId);
        if (this.config.getGenerateXmlReport() == null || this.config.getGenerateXmlReport().booleanValue()) {
            byte[] cxReport = this.getScanReport(sastResults.getScanId(), ReportType.XML, "application/xml;v=1.0");
            CxXMLResults reportObj = SASTUtils.convertToXMLResult(cxReport);
            sastResults.setScanDetailedReport(reportObj);
            sastResults.setRawXMLReport(cxReport);
        }
        sastResults.setSastResultsReady(true);
        return sastResults;
    }

    SASTResults getLatestSASTResults(long projectId) throws IOException, CxClientException, InterruptedException {
        this.log.info("---------------------------------Get Last CxSAST Results:--------------------------------");
        List<LastScanResponse> scanList = this.getLatestSASTStatus(projectId);
        for (LastScanResponse s : scanList) {
            if (!CurrentStatus.FINISHED.value().equals(s.getStatus().getName())) continue;
            return this.retrieveSASTResults(s.getId(), projectId);
        }
        return new SASTResults();
    }

    public void cancelSASTScan(long scanId) throws IOException, CxClientException {
        UpdateScanStatusRequest request = new UpdateScanStatusRequest(CurrentStatus.CANCELED);
        String json = HttpClientHelper.convertToJson(request);
        StringEntity entity = new StringEntity(json, StandardCharsets.UTF_8);
        this.httpClient.patchRequest("sast/scansQueue/{scanId}".replace("{scanId}", Long.toString(scanId)), "application/json;v=1.0", (HttpEntity)entity, 200, "cancel SAST scan");
        this.log.info("SAST Scan canceled. (scanId: " + scanId + ")");
    }

    private boolean projectHasQueuedScans(long projectId) throws IOException, CxClientException {
        List<ResponseQueueScanStatus> queuedScans = this.getQueueScans(projectId);
        for (ResponseQueueScanStatus scan : queuedScans) {
            if (!this.isStatusToAvoid(scan.getStage().getValue()) || scan.getProject().getId() != projectId) continue;
            return true;
        }
        return false;
    }

    private boolean isStatusToAvoid(String status) {
        QueueStatus qStatus = QueueStatus.valueOf(status);
        switch (qStatus) {
            case New: 
            case PreScan: 
            case SourcePullingAndDeployment: 
            case Queued: 
            case Scanning: 
            case PostScan: {
                return true;
            }
        }
        return false;
    }

    private ScanSettingResponse getScanSetting(long projectId) throws IOException, CxClientException {
        return this.httpClient.getRequest("/sast/scanSettings/{projectId}".replace("{projectId}", Long.toString(projectId)), "application/json;v=1.0", ScanSettingResponse.class, 200, "Scan setting", false);
    }

    private void defineScanSetting(ScanSettingRequest scanSetting) throws IOException, CxClientException {
        StringEntity entity = new StringEntity(HttpClientHelper.convertToJson(scanSetting), StandardCharsets.UTF_8);
        this.httpClient.putRequest("sast/pluginsScanSettings", "application/json;v=1.0", (HttpEntity)entity, CxID.class, 200, "define scan setting");
    }

    private void uploadZipFile(File zipFile, long projectId) throws CxClientException, IOException {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        builder.addBinaryBody("zippedSource", zipFile);
        HttpEntity entity = builder.build();
        this.httpClient.postRequest("projects/{projectId}/sourceCode/attachments".replace("{projectId}", Long.toString(projectId)), null, entity, null, 204, "upload ZIP file");
    }

    private CxID createScan(CreateScanRequest request) throws CxClientException, IOException {
        StringEntity entity = new StringEntity(HttpClientHelper.convertToJson(request), StandardCharsets.UTF_8);
        return this.httpClient.postRequest("sast/scans", "application/json;v=1.0", (HttpEntity)entity, CxID.class, 201, "create new SAST Scan");
    }

    private CxID createRemoteSourceScan(long projectId, HttpEntity entity, String sourceType) throws IOException, CxClientException {
        return this.httpClient.postRequest("projects/{projectId}/sourceCode/remoteSettings/{sourceType}".replace("{projectId}", Long.toString(projectId)).replace("{sourceType}", sourceType), "application/json;v=1.0", entity, CxID.class, 204, "create " + sourceType + " remote source scan setting");
    }

    private SASTStatisticsResponse getScanStatistics(long scanId) throws CxClientException, IOException {
        return this.httpClient.getRequest("sast/scans/{scanId}/resultsStatistics".replace("{scanId}", Long.toString(scanId)), "application/json;v=1.0", SASTStatisticsResponse.class, 200, "SAST scan statistics", false);
    }

    private List<LastScanResponse> getLatestSASTStatus(long projectId) throws CxClientException, IOException {
        return (List)((Object)this.httpClient.getRequest("sast/scans?projectId={projectId}".replace("{projectId}", Long.toString(projectId)), "application/json;v=1.0", LastScanResponse.class, 200, "last SAST scan ID", true));
    }

    private List<ResponseQueueScanStatus> getQueueScans(long projectId) throws IOException, CxClientException {
        return (List)((Object)this.httpClient.getRequest("sast/scansQueue?projectId={projectId}".replace("{projectId}", Long.toString(projectId)), "application/json;v=1.0", ResponseQueueScanStatus.class, 200, "scans in the queue. (projectId: )" + projectId, true));
    }

    private CreateReportResponse createScanReport(CreateReportRequest reportRequest) throws CxClientException, IOException {
        StringEntity entity = new StringEntity(HttpClientHelper.convertToJson(reportRequest), StandardCharsets.UTF_8);
        return this.httpClient.postRequest("reports/sastScan/", "application/json;v=1.0", (HttpEntity)entity, CreateReportResponse.class, 202, "to create " + reportRequest.getReportType() + " scan report");
    }

    private byte[] getScanReport(long scanId, ReportType reportType, String contentType) throws CxClientException, IOException, InterruptedException {
        CreateReportRequest reportRequest = new CreateReportRequest(scanId, reportType.name());
        CreateReportResponse createReportResponse = this.createScanReport(reportRequest);
        int reportId = createReportResponse.getReportId();
        this.reportWaiter.waitForTaskToFinish(Long.toString(reportId), this.reportTimeoutSec, this.log);
        return this.getReport(reportId, contentType);
    }

    private byte[] getReport(long reportId, String contentType) throws CxClientException, IOException {
        return this.httpClient.getRequest("reports/sastScan/{reportId}".replace("{reportId}", Long.toString(reportId)), contentType, byte[].class, 200, " scan report: " + reportId, false);
    }

    private ResponseQueueScanStatus getSASTScanStatus(String scanId) throws CxClientException, IOException {
        ResponseQueueScanStatus scanStatus = this.httpClient.getRequest("sast/scansQueue/{scanId}".replace("{scanId}", scanId), "application/json;v=1.0", ResponseQueueScanStatus.class, 200, "SAST scan status", false);
        String currentStatus = scanStatus.getStage().getValue();
        if (CurrentStatus.FAILED.value().equals(currentStatus) || CurrentStatus.CANCELED.value().equals(currentStatus) || CurrentStatus.DELETED.value().equals(currentStatus) || CurrentStatus.UNKNOWN.value().equals(currentStatus)) {
            scanStatus.setBaseStatus(Status.FAILED);
        } else if (CurrentStatus.FINISHED.value().equals(currentStatus)) {
            scanStatus.setBaseStatus(Status.SUCCEEDED);
        } else {
            scanStatus.setBaseStatus(Status.IN_PROGRESS);
        }
        return scanStatus;
    }

    private void printSASTProgress(ResponseQueueScanStatus scanStatus, long startTime) {
        long elapsedSec = System.currentTimeMillis() / 1000L - startTime;
        long hours = elapsedSec / 3600L;
        long minutes = elapsedSec % 3600L / 60L;
        long seconds = elapsedSec % 60L;
        String hoursStr = hours < 10L ? "0" + Long.toString(hours) : Long.toString(hours);
        String minutesStr = minutes < 10L ? "0" + Long.toString(minutes) : Long.toString(minutes);
        String secondsStr = seconds < 10L ? "0" + Long.toString(seconds) : Long.toString(seconds);
        String prefix = scanStatus.getTotalPercent() < 10 ? " " : "";
        this.log.info("Waiting for SAST scan results. Elapsed time: " + hoursStr + ":" + minutesStr + ":" + secondsStr + ". " + prefix + scanStatus.getTotalPercent() + "% processed. Status: " + scanStatus.getStage().getValue() + ".");
    }

    private ResponseQueueScanStatus resolveSASTStatus(ResponseQueueScanStatus scanStatus) throws CxClientException {
        if (scanStatus != null && Status.SUCCEEDED == scanStatus.getBaseStatus()) {
            this.log.info("SAST scan finished successfully.");
            return scanStatus;
        }
        throw new CxClientException("SAST scan cannot be completed. status [" + scanStatus.getStage().getValue() + "]: " + scanStatus.getStageDetails());
    }

    private ReportStatus getReportStatus(String reportId) throws CxClientException, IOException {
        ReportStatus reportStatus = this.httpClient.getRequest("reports/sastScan/{reportId}/status".replace("{reportId}", reportId), "application/json;v=1.0", ReportStatus.class, 200, " report status", false);
        reportStatus.setBaseId(reportId);
        String currentStatus = reportStatus.getStatus().getValue();
        if (currentStatus.equals(ReportStatusEnum.INPROCESS.value())) {
            reportStatus.setBaseStatus(Status.IN_PROGRESS);
        } else if (currentStatus.equals(ReportStatusEnum.FAILED.value())) {
            reportStatus.setBaseStatus(Status.FAILED);
        } else {
            reportStatus.setBaseStatus(Status.SUCCEEDED);
        }
        return reportStatus;
    }

    private void printReportProgress(ReportStatus reportStatus, long startTime) {
        String reportType = reportStatus.getContentType().replace("application/", "");
        this.log.info("Waiting for server to generate " + reportType + " report. " + (startTime + (long)this.reportTimeoutSec - System.currentTimeMillis() / 1000L) + " seconds left to timeout");
    }

    private ReportStatus resolveReportStatus(ReportStatus reportStatus) throws CxClientException {
        if (reportStatus != null && Status.SUCCEEDED == reportStatus.getBaseStatus()) {
            return reportStatus;
        }
        throw new CxClientException("Generation of scan report [id=" + reportStatus.getBaseId() + "] failed.");
    }

    private CxARMStatus getCxARMStatus(String projectId) throws CxClientException, IOException {
        CxARMStatus cxARMStatus = this.httpClient.getRequest("sast/projects/{projectId}/publisher/policyFindings/status".replace("{projectId}", projectId), "application/json;v=1.0", CxARMStatus.class, 200, " cxARM status", false);
        cxARMStatus.setBaseId(projectId);
        String currentStatus = cxARMStatus.getStatus();
        if (currentStatus.equals(CxARMStatusEnum.IN_PROGRESS.value())) {
            cxARMStatus.setBaseStatus(Status.IN_PROGRESS);
        } else if (currentStatus.equals(CxARMStatusEnum.FAILED.value())) {
            cxARMStatus.setBaseStatus(Status.FAILED);
        } else if (currentStatus.equals(CxARMStatusEnum.FINISHED.value())) {
            cxARMStatus.setBaseStatus(Status.SUCCEEDED);
        } else {
            cxARMStatus.setBaseStatus(Status.FAILED);
        }
        return cxARMStatus;
    }

    private void printCxARMProgress(CxARMStatus cxARMStatus, long startTime) {
        this.log.info("Waiting for server to retrieve policy violations. " + (startTime + (long)this.cxARMTimeoutSec - System.currentTimeMillis() / 1000L) + " seconds left to timeout");
    }

    private CxARMStatus resolveCxARMStatus(CxARMStatus cxARMStatus) throws CxClientException {
        if (cxARMStatus != null && Status.SUCCEEDED == cxARMStatus.getBaseStatus()) {
            return cxARMStatus;
        }
        throw new CxClientException("Getting policy violations of project [id=" + cxARMStatus.getBaseId() + "] failed.");
    }
}

