/*
 * Decompiled with CFR 0.152.
 */
package com.cx.restclient;

import com.cx.restclient.CxOSAClient;
import com.cx.restclient.CxSASTClient;
import com.cx.restclient.common.summary.SummaryUtils;
import com.cx.restclient.configuration.CxScanConfig;
import com.cx.restclient.cxArm.dto.CxArmConfig;
import com.cx.restclient.cxArm.utils.CxARMUtils;
import com.cx.restclient.dto.CxVersion;
import com.cx.restclient.dto.Team;
import com.cx.restclient.exception.CxClientException;
import com.cx.restclient.exception.CxHTTPClientException;
import com.cx.restclient.httpClient.CxHttpClient;
import com.cx.restclient.httpClient.utils.HttpClientHelper;
import com.cx.restclient.osa.dto.OSAResults;
import com.cx.restclient.sast.dto.CreateProjectRequest;
import com.cx.restclient.sast.dto.CxNameObj;
import com.cx.restclient.sast.dto.Preset;
import com.cx.restclient.sast.dto.Project;
import com.cx.restclient.sast.dto.SASTResults;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Properties;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpResponseException;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;

public class CxShragaClient {
    private CxHttpClient httpClient;
    private Logger log;
    private CxScanConfig config;
    private long projectId;
    private CxSASTClient sastClient;
    private CxOSAClient osaClient;
    private long sastScanId;
    private String osaScanId;
    private SASTResults sastResults = new SASTResults();
    private OSAResults osaResults = new OSAResults();

    public CxShragaClient(CxScanConfig config, Logger log, String proxyHost, int proxyPort, String proxyUser, String proxyPassword) throws MalformedURLException, CxClientException {
        this.config = config;
        this.log = log;
        this.httpClient = new CxHttpClient(config.getUrl(), config.getUsername(), config.getPassword(), config.getCxOrigin(), config.isDisableCertificateValidation(), log, proxyHost, proxyPort, proxyUser, proxyPassword);
        this.sastClient = new CxSASTClient(this.httpClient, log, config);
        this.osaClient = new CxOSAClient(this.httpClient, log, config);
    }

    public CxShragaClient(CxScanConfig config, Logger log) throws MalformedURLException, CxClientException {
        this.config = config;
        this.log = log;
        this.httpClient = new CxHttpClient(config.getUrl(), config.getUsername(), config.getPassword(), config.getCxOrigin(), config.isDisableCertificateValidation(), log);
        this.sastClient = new CxSASTClient(this.httpClient, log, config);
        this.osaClient = new CxOSAClient(this.httpClient, log, config);
    }

    public CxShragaClient(String serverUrl, String username, String password, String origin, boolean disableCertificateValidation, Logger log, String proxyHost, int proxyPort, String proxyUser, String proxyPassword) throws MalformedURLException, CxClientException {
        this(new CxScanConfig(serverUrl, username, password, origin, disableCertificateValidation), log, proxyHost, proxyPort, proxyUser, proxyPassword);
    }

    public CxShragaClient(String serverUrl, String username, String password, String origin, boolean disableCertificateValidation, Logger log) throws MalformedURLException, CxClientException {
        this(new CxScanConfig(serverUrl, username, password, origin, disableCertificateValidation), log);
    }

    public String getClientVersion() {
        String version = "";
        try {
            Properties properties = new Properties();
            InputStream is = this.getClass().getClassLoader().getResourceAsStream("common.properties");
            if (is != null) {
                properties.load(is);
                version = properties.getProperty("version");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return version;
    }

    public void init() throws CxClientException, IOException {
        this.log.info("Initializing Cx client [" + this.getClientVersion() + "]");
        this.getCxVersion();
        this.login();
        this.resolveTeam();
        if (this.config.getSastEnabled().booleanValue()) {
            this.resolvePreset();
        }
        if (this.config.getEnablePolicyViolations()) {
            this.resolveCxARMUrl();
        }
        this.resolveProject();
    }

    public long createSASTScan() throws IOException, CxClientException {
        this.sastScanId = this.sastClient.createSASTScan(this.projectId);
        this.sastResults.setSastScanLink(this.config.getUrl(), this.sastScanId, this.projectId);
        return this.sastScanId;
    }

    public String createOSAScan() throws IOException, CxClientException {
        this.osaScanId = this.osaClient.createOSAScan(this.projectId);
        this.osaResults.setOsaProjectSummaryLink(this.config.getUrl(), this.projectId);
        return this.osaScanId;
    }

    public void cancelSASTScan() throws IOException, CxClientException {
        this.sastClient.cancelSASTScan(this.sastScanId);
    }

    public SASTResults waitForSASTResults() throws InterruptedException, CxClientException, IOException {
        this.sastResults = this.sastClient.waitForSASTResults(this.sastScanId, this.projectId);
        return this.sastResults;
    }

    public SASTResults getLatestSASTResults() throws InterruptedException, CxClientException, IOException {
        this.sastResults = this.sastClient.getLatestSASTResults(this.projectId);
        return this.sastResults;
    }

    public OSAResults waitForOSAResults() throws InterruptedException, CxClientException, IOException {
        this.osaResults = this.osaClient.getOSAResults(this.osaScanId, this.projectId);
        return this.osaResults;
    }

    public OSAResults getLatestOSAResults() throws InterruptedException, CxClientException, IOException {
        this.osaResults = this.osaClient.getLatestOSAResults(this.projectId);
        return this.osaResults;
    }

    public void printIsProjectViolated() {
        if (this.config.getEnablePolicyViolations()) {
            this.log.info("-----------------------------------------------------------------------------------------");
            this.log.info("Policy Management: ");
            this.log.info("--------------------");
            if (this.sastResults.getSastPolicies().isEmpty() && this.osaResults.getOsaPolicies().isEmpty()) {
                this.log.info("Project policy status : compliant");
                this.log.info("-----------------------------------------------------------------------------------------");
            } else {
                this.log.info("Project policy status : violated");
                if (!this.sastResults.getSastPolicies().isEmpty()) {
                    this.log.info("SAST violated policies names: " + CxARMUtils.getPoliciesNames(this.sastResults.getSastPolicies()));
                }
                if (!this.osaResults.getOsaPolicies().isEmpty()) {
                    this.log.info("OSA violated policies names: " + CxARMUtils.getPoliciesNames(this.osaResults.getOsaPolicies()));
                }
                this.log.info("-----------------------------------------------------------------------------------------");
            }
        }
    }

    private CxArmConfig getCxARMConfig() throws IOException, CxClientException {
        return this.httpClient.getRequest("/Configurations/Portal", "application/json;v=1.0", CxArmConfig.class, 200, "CxARM URL", false);
    }

    public String generateHTMLSummary() throws Exception {
        return SummaryUtils.generateSummary(this.sastResults, this.osaResults, this.config);
    }

    public String generateHTMLSummary(SASTResults sastResults, OSAResults osaResults) throws Exception {
        return SummaryUtils.generateSummary(sastResults, osaResults, this.config);
    }

    public List<Project> getAllProjects() throws IOException, CxClientException {
        List projects;
        block2: {
            projects = null;
            try {
                projects = (List)((Object)this.httpClient.getRequest("projects", "application/json;v=1.0", Project.class, 200, "all projects", true));
            }
            catch (HttpResponseException ex) {
                if (ex.getStatusCode() == 404) break block2;
                throw ex;
            }
        }
        return projects;
    }

    public void close() {
        this.httpClient.close();
    }

    public void login() throws IOException, CxClientException {
        this.log.info("Logging into the Checkmarx service.");
        this.httpClient.login();
    }

    public void getCxVersion() throws IOException, CxClientException {
        try {
            this.config.setCxVersion(this.httpClient.getRequest("system/version", "application/json;v=1.0", CxVersion.class, 200, "cx Version", false));
            String hotfix = "";
            try {
                if (this.config.getCxVersion().getHotFix() != null && Integer.parseInt(this.config.getCxVersion().getHotFix()) > 0) {
                    hotfix = " Hotfix [" + this.config.getCxVersion().getHotFix() + "].";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.log.info("Checkmarx server version [" + this.config.getCxVersion().getVersion() + "]." + hotfix);
        }
        catch (Exception ex) {
            this.log.debug("Checkmarx server version [lower than 9.0]");
        }
    }

    public String getTeamIdByName(String teamName) throws CxClientException, IOException {
        teamName = this.replaceDelimiters(teamName);
        List<Team> allTeams = this.getTeamList();
        for (Team team : allTeams) {
            String fullName = this.replaceDelimiters(team.getFullName());
            if (!fullName.equalsIgnoreCase(teamName)) continue;
            return team.getId();
        }
        throw new CxClientException("Could not resolve team ID from team name: " + teamName);
    }

    private String replaceDelimiters(String teamName) {
        while (teamName.contains("\\") || teamName.contains("//")) {
            teamName = teamName.replace("\\", "/");
            teamName = teamName.replace("//", "/");
        }
        return teamName;
    }

    public String getTeamNameById(String teamId) throws CxClientException, IOException {
        List<Team> allTeams = this.getTeamList();
        for (Team team : allTeams) {
            if (!teamId.equals(team.getId())) continue;
            return team.getFullName();
        }
        throw new CxClientException("Could not resolve team name from id: " + teamId);
    }

    public int getPresetIdByName(String presetName) throws CxClientException, IOException {
        List<Preset> allPresets = this.getPresetList();
        for (Preset preset : allPresets) {
            if (!preset.getName().equalsIgnoreCase(presetName)) continue;
            return preset.getId();
        }
        throw new CxClientException("Could not resolve preset ID from preset name: " + presetName);
    }

    public List<Team> getTeamList() throws IOException, CxClientException {
        return (List)((Object)this.httpClient.getRequest("auth/teams", "application/json;v=1.0", Team.class, 200, "team list", true));
    }

    public Preset getPresetById(int presetId) throws IOException, CxClientException {
        return this.httpClient.getRequest("sast/presets/" + presetId, "application/json;v=1.0", Preset.class, 200, "preset by id", false);
    }

    public List<Preset> getPresetList() throws IOException, CxClientException {
        return (List)((Object)this.httpClient.getRequest("sast/presets", "application/json;v=1.0", Preset.class, 200, "preset list", true));
    }

    public List<CxNameObj> getConfigurationSetList() throws IOException, CxClientException {
        return (List)((Object)this.httpClient.getRequest("sast/engineConfigurations", "application/json;v=1.0", CxNameObj.class, 200, "engine configurations", true));
    }

    public void setOsaFSAProperties(Properties fsaConfig) {
        this.config.setOsaFsaConfig(fsaConfig);
    }

    private void resolveTeam() throws CxClientException, IOException {
        if (this.config.getTeamId() == null) {
            this.config.setTeamId(this.getTeamIdByName(this.config.getTeamPath()));
        }
        this.printTeamPath();
    }

    private void resolveCxARMUrl() {
        try {
            this.config.setCxARMUrl(this.getCxARMConfig().getCxARMPolicyURL());
        }
        catch (Exception ex) {
            this.log.error("CxARM is not available. Policy violations cannot be calculated: " + ex.getMessage());
        }
    }

    private void resolvePreset() throws CxClientException, IOException {
        if (this.config.getPresetId() == null) {
            this.config.setPresetId(this.getPresetIdByName(this.config.getPresetName()));
        }
        this.printPresetName();
    }

    private void printPresetName() {
        try {
            String presetName = this.config.getPresetName();
            if (presetName == null) {
                presetName = this.getPresetById(this.config.getPresetId()).getName();
            }
            this.log.info("preset name: " + presetName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void printTeamPath() {
        try {
            String teamPath = this.config.getTeamPath();
            if (teamPath == null) {
                teamPath = this.getTeamNameById(this.config.getTeamId());
            }
            this.log.info("full team path: " + teamPath);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void resolveProject() throws IOException, CxClientException {
        List<Project> projects = this.getProjectByName(this.config.getProjectName(), this.config.getTeamId());
        if (projects == null || projects.isEmpty()) {
            if (this.config.getDenyProject().booleanValue()) {
                throw new CxClientException("Creation of the new project [{projectName}] is not authorized. Please use an existing project. \nYou can enable the creation of new projects by disabling the Deny new Checkmarx projects creation checkbox in the Checkmarx plugin global settings.\n".replace("{projectName}", this.config.getProjectName()));
            }
            CreateProjectRequest request = new CreateProjectRequest(this.config.getProjectName(), this.config.getTeamId(), this.config.getPublic());
            this.projectId = this.createNewProject(request).getId();
        } else {
            this.projectId = projects.get(0).getId();
        }
    }

    private List<Project> getProjectByName(String projectName, String teamId) throws IOException, CxClientException {
        List projects;
        block2: {
            projectName = URLEncoder.encode(projectName, "UTF-8");
            String projectNamePath = "projects?projectname={name}&teamid={teamId}".replace("{name}", projectName).replace("{teamId}", teamId);
            projects = null;
            try {
                projects = (List)((Object)this.httpClient.getRequest(projectNamePath, "application/json;v=1.0", Project.class, 200, "project by name: " + projectName, true));
            }
            catch (CxHTTPClientException ex) {
                if (ex.getStatusCode() == 404) break block2;
                throw ex;
            }
        }
        return projects;
    }

    private Project createNewProject(CreateProjectRequest request) throws CxClientException, IOException {
        String json = HttpClientHelper.convertToJson(request);
        StringEntity entity = new StringEntity(json, StandardCharsets.UTF_8);
        return this.httpClient.postRequest("projects", "application/json;v=1.0", (HttpEntity)entity, Project.class, 201, "create new project: " + request.getName());
    }
}

