/*
 * Decompiled with CFR 0.152.
 */
package com.cx.restclient.common;

import com.cx.restclient.configuration.CxScanConfig;
import com.cx.restclient.osa.dto.OSAResults;
import com.cx.restclient.sast.dto.SASTResults;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public abstract class ShragaUtils {
    public static final String INCLUDES_LIST = "includes";
    public static final String EXCLUDES_LIST = "excludes";

    public static String getBuildFailureResult(CxScanConfig config, SASTResults sastResults, OSAResults osaResults) {
        StringBuilder res = new StringBuilder("");
        ShragaUtils.isThresholdExceeded(config, sastResults, osaResults, res);
        ShragaUtils.isThresholdForNewResultExceeded(config, sastResults, res);
        ShragaUtils.isPolicyViolated(config, sastResults, osaResults, res);
        return res.toString();
    }

    public static boolean isPolicyViolated(CxScanConfig config, SASTResults sastResults, OSAResults osaResults, StringBuilder res) {
        boolean isPolicyViolated;
        boolean bl = isPolicyViolated = config.getEnablePolicyViolations() && (osaResults != null && osaResults.getOsaPolicies().size() > 0 || sastResults != null && sastResults.getSastPolicies().size() > 0);
        if (isPolicyViolated) {
            res.append("Project policy status : violated").append("\n");
        }
        return isPolicyViolated;
    }

    public static boolean isThresholdExceeded(CxScanConfig config, SASTResults sastResults, OSAResults osaResults, StringBuilder res) {
        boolean thresholdExceeded = false;
        if (config.isSASTThresholdEffectivelyEnabled() && sastResults != null && sastResults.isSastResultsReady()) {
            thresholdExceeded = ShragaUtils.isSeverityExceeded(sastResults.getHigh(), config.getSastHighThreshold(), res, "high", "CxSAST ");
            thresholdExceeded |= ShragaUtils.isSeverityExceeded(sastResults.getMedium(), config.getSastMediumThreshold(), res, "medium", "CxSAST ");
            thresholdExceeded |= ShragaUtils.isSeverityExceeded(sastResults.getLow(), config.getSastLowThreshold(), res, "low", "CxSAST ");
        }
        if (config.isOSAThresholdEffectivelyEnabled() && osaResults != null && osaResults.isOsaResultsReady()) {
            thresholdExceeded |= ShragaUtils.isSeverityExceeded(osaResults.getResults().getTotalHighVulnerabilities(), config.getOsaHighThreshold(), res, "high", "CxOSA  ");
            thresholdExceeded |= ShragaUtils.isSeverityExceeded(osaResults.getResults().getTotalMediumVulnerabilities(), config.getOsaMediumThreshold(), res, "medium", "CxOSA  ");
            thresholdExceeded |= ShragaUtils.isSeverityExceeded(osaResults.getResults().getTotalLowVulnerabilities(), config.getOsaLowThreshold(), res, "low", "CxOSA  ");
        }
        return thresholdExceeded;
    }

    public static boolean isThresholdForNewResultExceeded(CxScanConfig config, SASTResults sastResults, StringBuilder res) {
        boolean exceeded = false;
        if (sastResults != null && sastResults.isSastResultsReady() && config.getSastNewResultsThresholdEnabled().booleanValue()) {
            String severity = config.getSastNewResultsThresholdSeverity();
            if ("LOW".equals(severity)) {
                if (sastResults.getNewLow() > 0) {
                    res.append("One or more new results of low severity\n");
                    exceeded = true;
                }
                severity = "MEDIUM";
            }
            if ("MEDIUM".equals(severity)) {
                if (sastResults.getNewMedium() > 0) {
                    res.append("One or more new results of medium severity\n");
                    exceeded = true;
                }
                severity = "HIGH";
            }
            if ("HIGH".equals(severity) && sastResults.getNewHigh() > 0) {
                res.append("One or more New results of high severity\n");
                exceeded = true;
            }
        }
        return exceeded;
    }

    private static boolean isSeverityExceeded(int result, Integer threshold, StringBuilder res, String severity, String severityType) {
        boolean fail = false;
        if (threshold != null && result > threshold) {
            res.append(severityType).append(severity).append(" severity results are above threshold. Results: ").append(result).append(". Threshold: ").append(threshold).append(". \n");
            fail = true;
        }
        return fail;
    }

    public static Map<String, List<String>> generateIncludesExcludesPatternLists(String folderExclusions, String filterPattern, Logger log) {
        String excludeFoldersPattern = ShragaUtils.processExcludeFolders(folderExclusions, log);
        String combinedPatterns = "";
        combinedPatterns = StringUtils.isEmpty((CharSequence)filterPattern) && StringUtils.isEmpty((CharSequence)excludeFoldersPattern) ? "" : (!StringUtils.isEmpty((CharSequence)filterPattern) && StringUtils.isEmpty((CharSequence)excludeFoldersPattern) ? filterPattern : (StringUtils.isEmpty((CharSequence)filterPattern) && !StringUtils.isEmpty((CharSequence)excludeFoldersPattern) ? excludeFoldersPattern : filterPattern + "," + excludeFoldersPattern));
        return ShragaUtils.convertPatternsToLists(combinedPatterns);
    }

    public static String processExcludeFolders(String folderExclusions, Logger log) {
        String[] patterns;
        if (StringUtils.isEmpty((CharSequence)folderExclusions)) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (String p : patterns = StringUtils.split((String)folderExclusions, (String)",\n")) {
            if ((p = p.trim()).length() <= 0) continue;
            result.append("!**/");
            result.append(p);
            result.append("/**,");
        }
        log.info("Exclude folders converted to: '" + result.toString() + "'");
        return result.toString();
    }

    public static Map<String, List<String>> convertPatternsToLists(String filterPatterns) {
        String[] filters;
        filterPatterns = StringUtils.defaultString((String)filterPatterns);
        ArrayList<String> inclusions = new ArrayList<String>();
        ArrayList<String> exclusions = new ArrayList<String>();
        for (String filter : filters = filterPatterns.replace("\n", "").replace("\r", "").split("\\s*,\\s*")) {
            if (!StringUtils.isNotEmpty((CharSequence)filter)) continue;
            if (!filter.startsWith("!")) {
                inclusions.add(filter.trim());
                continue;
            }
            if (filter.length() <= 1) continue;
            filter = filter.substring(1);
            exclusions.add(filter.trim());
        }
        HashMap<String, List<String>> ret = new HashMap<String, List<String>>();
        ret.put(INCLUDES_LIST, inclusions);
        ret.put(EXCLUDES_LIST, exclusions);
        return ret;
    }

    public static String formatDate(String date, String fromFormat, String toFormat) {
        SimpleDateFormat fromDate = new SimpleDateFormat(fromFormat);
        SimpleDateFormat toDate = new SimpleDateFormat(toFormat);
        String ret = "";
        try {
            ret = toDate.format(fromDate.parse(date));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }
}

