/*
 * Decompiled with CFR 0.152.
 */
package com.cx.restclient.common;

import com.cx.restclient.dto.BaseStatus;
import com.cx.restclient.dto.Status;
import com.cx.restclient.exception.CxClientException;
import java.io.IOException;
import java.util.Date;
import org.slf4j.Logger;

public abstract class Waiter<T> {
    private int retry = 3;
    private String scanType;
    private int sleepIntervalSec;
    private long startTimeSec;
    protected Status status = null;

    public Waiter(String scanType, int interval) {
        this.scanType = scanType;
        this.sleepIntervalSec = interval;
    }

    public T waitForTaskToFinish(String taskId, Integer scanTimeoutSec, Logger log) throws CxClientException, InterruptedException {
        T obj;
        this.startTimeSec = System.currentTimeMillis() / 1000L;
        long elapsedTimeSec = 0L;
        try {
            obj = this.getStatus(taskId);
            this.status = ((BaseStatus)obj).getBaseStatus();
            while (this.status.equals((Object)Status.IN_PROGRESS) && (scanTimeoutSec <= 0 || elapsedTimeSec < (long)scanTimeoutSec.intValue())) {
                Thread.sleep(this.sleepIntervalSec * 1000);
                try {
                    obj = this.getStatus(taskId);
                    this.status = ((BaseStatus)obj).getBaseStatus();
                    log.debug(this.status.value());
                }
                catch (Exception e) {
                    log.debug("Failed to get status from " + this.scanType + ". retrying (" + (this.retry - 1) + " tries left). Error message: " + e.getMessage());
                    --this.retry;
                    if (this.retry > 0) continue;
                    throw new CxClientException("Failed to get status from " + this.scanType + ". Error message: " + e.getMessage(), e);
                }
                elapsedTimeSec = new Date().getTime() / 1000L - this.startTimeSec;
                this.printProgress(obj);
            }
            if (scanTimeoutSec > 0 && (long)scanTimeoutSec.intValue() <= elapsedTimeSec) {
                throw new CxClientException("Failed to perform " + this.scanType + ": " + this.scanType + " has been automatically aborted: reached the user-specified timeout (" + scanTimeoutSec / 60 + " minutes)");
            }
        }
        catch (Exception e) {
            throw new CxClientException("Failed to get status from " + this.scanType + ". Error message: " + e.getMessage(), e);
        }
        return this.resolveStatus(obj);
    }

    public abstract T getStatus(String var1) throws CxClientException, IOException;

    public abstract void printProgress(T var1);

    public abstract T resolveStatus(T var1) throws CxClientException;

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public long getStartTimeSec() {
        return this.startTimeSec;
    }
}

