/*
 * Decompiled with CFR 0.152.
 */
package com.cx.restclient.common.summary;

import com.cx.restclient.common.ShragaUtils;
import com.cx.restclient.configuration.CxScanConfig;
import com.cx.restclient.cxArm.dto.Policy;
import com.cx.restclient.osa.dto.OSAResults;
import com.cx.restclient.osa.dto.OSASummaryResults;
import com.cx.restclient.sast.dto.SASTResults;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.Version;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class SummaryUtils {
    public static String generateSummary(SASTResults sastResults, OSAResults osaResults, CxScanConfig config) throws IOException, TemplateException {
        Configuration cfg = new Configuration(new Version("2.3.23"));
        cfg.setClassForTemplateLoading(SummaryUtils.class, "/com/cx/report");
        Template template = cfg.getTemplate("report.ftl");
        HashMap<String, Object> templateData = new HashMap<String, Object>();
        templateData.put("config", config);
        templateData.put("sast", sastResults);
        templateData.put("osa", osaResults);
        boolean buildFailed = false;
        boolean policyViolated = false;
        int policyViolatedCount = 0;
        if (config.getSastEnabled().booleanValue()) {
            if (sastResults.isSastResultsReady()) {
                boolean sastThresholdExceeded = ShragaUtils.isThresholdExceeded(config, sastResults, null, new StringBuilder());
                boolean sastNewResultsExceeded = ShragaUtils.isThresholdForNewResultExceeded(config, sastResults, new StringBuilder());
                templateData.put("sastThresholdExceeded", sastThresholdExceeded);
                templateData.put("sastNewResultsExceeded", sastNewResultsExceeded);
                buildFailed = sastThresholdExceeded || sastNewResultsExceeded;
                float maxCount = Math.max(sastResults.getHigh(), Math.max(sastResults.getMedium(), sastResults.getLow()));
                float sastBarNorm = maxCount * 10.0f / 9.0f;
                float sastHighTotalHeight = (float)sastResults.getHigh() / sastBarNorm * 238.0f;
                float sastHighNewHeight = SummaryUtils.calculateNewBarHeight(sastResults.getNewHigh(), sastResults.getHigh(), sastHighTotalHeight);
                float sastHighRecurrentHeight = sastHighTotalHeight - sastHighNewHeight;
                templateData.put("sastHighTotalHeight", Float.valueOf(sastHighTotalHeight));
                templateData.put("sastHighNewHeight", Float.valueOf(sastHighNewHeight));
                templateData.put("sastHighRecurrentHeight", Float.valueOf(sastHighRecurrentHeight));
                float sastMediumTotalHeight = (float)sastResults.getMedium() / sastBarNorm * 238.0f;
                float sastMediumNewHeight = SummaryUtils.calculateNewBarHeight(sastResults.getNewMedium(), sastResults.getMedium(), sastMediumTotalHeight);
                float sastMediumRecurrentHeight = sastMediumTotalHeight - sastMediumNewHeight;
                templateData.put("sastMediumTotalHeight", Float.valueOf(sastMediumTotalHeight));
                templateData.put("sastMediumNewHeight", Float.valueOf(sastMediumNewHeight));
                templateData.put("sastMediumRecurrentHeight", Float.valueOf(sastMediumRecurrentHeight));
                float sastLowTotalHeight = (float)sastResults.getLow() / sastBarNorm * 238.0f;
                float sastLowNewHeight = SummaryUtils.calculateNewBarHeight(sastResults.getNewLow(), sastResults.getLow(), sastLowTotalHeight);
                float sastLowRecurrentHeight = sastLowTotalHeight - sastLowNewHeight;
                templateData.put("sastLowTotalHeight", Float.valueOf(sastLowTotalHeight));
                templateData.put("sastLowNewHeight", Float.valueOf(sastLowNewHeight));
                templateData.put("sastLowRecurrentHeight", Float.valueOf(sastLowRecurrentHeight));
            } else {
                buildFailed = true;
            }
        }
        if (config.getOsaEnabled().booleanValue()) {
            if (osaResults.isOsaResultsReady()) {
                boolean osaThresholdExceeded = ShragaUtils.isThresholdExceeded(config, null, osaResults, new StringBuilder());
                templateData.put("osaThresholdExceeded", osaThresholdExceeded);
                buildFailed |= osaThresholdExceeded;
                OSASummaryResults osaSummaryResults = osaResults.getResults();
                int osaHigh = osaSummaryResults.getTotalHighVulnerabilities();
                int osaMedium = osaSummaryResults.getTotalMediumVulnerabilities();
                int osaLow = osaSummaryResults.getTotalLowVulnerabilities();
                float osaMaxCount = Math.max(osaHigh, Math.max(osaMedium, osaLow));
                float osaBarNorm = osaMaxCount * 10.0f / 9.0f;
                float osaHighTotalHeight = (float)osaHigh / osaBarNorm * 238.0f;
                float osaMediumTotalHeight = (float)osaMedium / osaBarNorm * 238.0f;
                float osaLowTotalHeight = (float)osaLow / osaBarNorm * 238.0f;
                templateData.put("osaHighTotalHeight", Float.valueOf(osaHighTotalHeight));
                templateData.put("osaMediumTotalHeight", Float.valueOf(osaMediumTotalHeight));
                templateData.put("osaLowTotalHeight", Float.valueOf(osaLowTotalHeight));
            } else {
                buildFailed = true;
            }
        }
        if (config.getEnablePolicyViolations()) {
            Map<String, String> policies = new HashMap<String, String>();
            if (config.getSastEnabled().booleanValue() && sastResults.getSastPolicies().size() > 0) {
                policyViolated = true;
                policies = sastResults.getSastPolicies().stream().collect(Collectors.toMap(Policy::getPolicyName, Policy::getRuleName, (left, right) -> left));
            }
            if (config.getOsaEnabled().booleanValue() && osaResults.getOsaPolicies().size() > 0) {
                policyViolated = true;
                policies.putAll(osaResults.getOsaPolicies().stream().collect(Collectors.toMap(Policy::getPolicyName, Policy::getRuleName, (left, right) -> left)));
            }
            String policyLabel = (policyViolatedCount = policies.size()) == 1 ? "Policy" : "Policies";
            templateData.put("policyLabel", policyLabel);
            templateData.put("policyViolatedCount", policyViolatedCount);
        }
        templateData.put("policyViolated", policyViolated);
        templateData.put("buildFailed", buildFailed |= policyViolated);
        StringWriter writer = new StringWriter();
        template.process(templateData, (Writer)writer);
        return writer.toString();
    }

    private static float calculateNewBarHeight(int newCount, int count, float totalHeight) {
        float highNewHeightPx = (float)newCount / (float)count * totalHeight;
        int minimalVisibilityHeight = 5;
        if (SummaryUtils.isNewNeedChange(totalHeight, highNewHeightPx, minimalVisibilityHeight)) {
            highNewHeightPx = minimalVisibilityHeight;
        }
        return highNewHeightPx;
    }

    private static boolean isNewNeedChange(float highTotalHeightPx, float highNewHeightPx, int minimalVisibilityHeight) {
        return highNewHeightPx > 0.0f && highNewHeightPx < (float)minimalVisibilityHeight && highTotalHeightPx > (float)(minimalVisibilityHeight * 2);
    }
}

