/*
 * Decompiled with CFR 0.152.
 */
package com.cx.restclient.configuration;

import com.cx.restclient.dto.CxVersion;
import com.cx.restclient.dto.RemoteSourceTypes;
import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class CxScanConfig
implements Serializable {
    private Boolean sastEnabled = false;
    private Boolean osaEnabled = false;
    private String cxOrigin;
    private CxVersion cxVersion;
    private boolean disableCertificateValidation = false;
    private boolean useSSOLogin = false;
    private String sourceDir;
    private File reportsDir;
    private String username;
    private String password;
    private String url;
    private String projectName;
    private String teamPath;
    private String teamId;
    private Boolean denyProject = false;
    private Boolean hideResults = false;
    private Boolean isPublic = true;
    private Boolean forceScan = false;
    private String presetName;
    private Integer presetId;
    private String sastFolderExclusions;
    private String sastFilterPattern;
    private Integer sastScanTimeoutInMinutes;
    private Integer osaScanTimeoutInMinutes;
    private String scanComment;
    private Boolean isIncremental = false;
    private Boolean isSynchronous = false;
    private Boolean sastThresholdsEnabled = false;
    private Integer sastHighThreshold;
    private Integer sastMediumThreshold;
    private Integer sastLowThreshold;
    private Boolean sastNewResultsThresholdEnabled = false;
    private String sastNewResultsThresholdSeverity;
    private Boolean generatePDFReport = false;
    private File zipFile;
    private Integer engineConfigurationId = 1;
    private String osaFolderExclusions;
    private String osaFilterPattern;
    private String osaArchiveIncludePatterns;
    private Boolean osaGenerateJsonReport = true;
    private Boolean osaRunInstall = false;
    private Boolean osaThresholdsEnabled = false;
    private Integer osaHighThreshold;
    private Integer osaMediumThreshold;
    private Integer osaLowThreshold;
    private Properties osaFsaConfig;
    private String osaDependenciesJson;
    private Boolean avoidDuplicateProjectScans = false;
    private boolean enablePolicyViolations = false;
    private Boolean generateXmlReport = true;
    private String cxARMUrl;
    private String[] paths;
    private RemoteSourceTypes remoteType = null;
    private String remoteSrcUser;
    private String remoteSrcPass;
    private String remoteSrcUrl;
    private int remoteSrcPort;
    private byte[] remoteSrcKeyFile;
    private String remoteSrcBranch;
    private String preforceMode;

    public CxScanConfig() {
    }

    public CxScanConfig(String url, String username, String password, String cxOrigin, boolean disableCertificateValidation) {
        this.url = url;
        this.username = username;
        this.password = password;
        this.cxOrigin = cxOrigin;
        this.disableCertificateValidation = disableCertificateValidation;
    }

    public Boolean getSastEnabled() {
        return this.sastEnabled;
    }

    public void setSastEnabled(Boolean sastEnabled) {
        this.sastEnabled = sastEnabled;
    }

    public Boolean getOsaEnabled() {
        return this.osaEnabled;
    }

    public void setOsaEnabled(Boolean osaEnabled) {
        this.osaEnabled = osaEnabled;
    }

    public String getCxOrigin() {
        return this.cxOrigin;
    }

    public void setCxOrigin(String cxOrigin) {
        this.cxOrigin = cxOrigin;
    }

    public boolean isDisableCertificateValidation() {
        return this.disableCertificateValidation;
    }

    public void setDisableCertificateValidation(boolean disableCertificateValidation) {
        this.disableCertificateValidation = disableCertificateValidation;
    }

    public boolean isUseSSOLogin() {
        return this.useSSOLogin;
    }

    public void setUseSSOLogin(boolean useSSOLogin) {
        this.useSSOLogin = useSSOLogin;
    }

    public Boolean getAvoidDuplicateProjectScans() {
        return this.avoidDuplicateProjectScans;
    }

    public String getSourceDir() {
        return this.sourceDir;
    }

    public void setSourceDir(String sourceDir) {
        this.sourceDir = sourceDir;
    }

    public File getReportsDir() {
        return this.reportsDir;
    }

    public void setReportsDir(File reportsDir) {
        this.reportsDir = reportsDir;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getTeamPath() {
        return this.teamPath;
    }

    public void setTeamPath(String teamPath) {
        if (!(StringUtils.isEmpty((CharSequence)teamPath) || teamPath.startsWith("\\") || teamPath.startsWith("/"))) {
            teamPath = "\\" + teamPath;
        }
        this.teamPath = teamPath;
    }

    public String getTeamId() {
        return this.teamId;
    }

    public void setTeamId(String teamId) {
        this.teamId = teamId;
    }

    public Boolean getDenyProject() {
        return this.denyProject;
    }

    public void setDenyProject(Boolean denyProject) {
        this.denyProject = denyProject;
    }

    public Boolean getPublic() {
        return this.isPublic;
    }

    public void setPublic(Boolean aPublic) {
        this.isPublic = aPublic;
    }

    public Boolean getForceScan() {
        return this.forceScan;
    }

    public void setForceScan(Boolean forceScan) {
        this.forceScan = forceScan;
    }

    public String getPresetName() {
        return this.presetName;
    }

    public void setPresetName(String presetName) {
        this.presetName = presetName;
    }

    public Integer getPresetId() {
        return this.presetId;
    }

    public void setPresetId(Integer presetId) {
        this.presetId = presetId;
    }

    public String getSastFolderExclusions() {
        return this.sastFolderExclusions;
    }

    public void setSastFolderExclusions(String sastFolderExclusions) {
        this.sastFolderExclusions = sastFolderExclusions;
    }

    public String getSastFilterPattern() {
        return this.sastFilterPattern;
    }

    public void setSastFilterPattern(String sastFilterPattern) {
        this.sastFilterPattern = sastFilterPattern;
    }

    public Integer getSastScanTimeoutInMinutes() {
        return this.sastScanTimeoutInMinutes == null ? -1 : this.sastScanTimeoutInMinutes;
    }

    public void setSastScanTimeoutInMinutes(Integer sastScanTimeoutInMinutes) {
        this.sastScanTimeoutInMinutes = sastScanTimeoutInMinutes;
    }

    public Integer getOsaScanTimeoutInMinutes() {
        return this.osaScanTimeoutInMinutes == null ? -1 : this.osaScanTimeoutInMinutes;
    }

    public void setOsaScanTimeoutInMinutes(Integer sastOsaScanTimeoutInMinutes) {
        this.osaScanTimeoutInMinutes = sastOsaScanTimeoutInMinutes;
    }

    public String getScanComment() {
        return this.scanComment;
    }

    public void setScanComment(String scanComment) {
        this.scanComment = scanComment;
    }

    public Boolean getIncremental() {
        return this.isIncremental;
    }

    public void setIncremental(Boolean incremental) {
        this.isIncremental = incremental;
    }

    public Boolean getSynchronous() {
        return this.isSynchronous;
    }

    public void setSynchronous(Boolean synchronous) {
        this.isSynchronous = synchronous;
    }

    public Boolean getSastThresholdsEnabled() {
        return this.sastThresholdsEnabled;
    }

    public void setSastThresholdsEnabled(Boolean sastThresholdsEnabled) {
        this.sastThresholdsEnabled = sastThresholdsEnabled;
    }

    public Integer getSastHighThreshold() {
        return this.sastHighThreshold;
    }

    public void setSastHighThreshold(Integer sastHighThreshold) {
        this.sastHighThreshold = sastHighThreshold;
    }

    public Integer getSastMediumThreshold() {
        return this.sastMediumThreshold;
    }

    public void setSastMediumThreshold(Integer sastMediumThreshold) {
        this.sastMediumThreshold = sastMediumThreshold;
    }

    public Integer getSastLowThreshold() {
        return this.sastLowThreshold;
    }

    public void setSastLowThreshold(Integer sastLowThreshold) {
        this.sastLowThreshold = sastLowThreshold;
    }

    public String getSastNewResultsThresholdSeverity() {
        return this.sastNewResultsThresholdSeverity;
    }

    public void setSastNewResultsThresholdSeverity(String sastNewResultsThresholdSeverity) {
        this.sastNewResultsThresholdSeverity = sastNewResultsThresholdSeverity;
    }

    public Boolean getSastNewResultsThresholdEnabled() {
        return this.sastNewResultsThresholdEnabled;
    }

    public void setSastNewResultsThresholdEnabled(Boolean sastNewResultsThresholdEnabled) {
        this.sastNewResultsThresholdEnabled = sastNewResultsThresholdEnabled;
    }

    public Boolean getGeneratePDFReport() {
        return this.generatePDFReport;
    }

    public void setGeneratePDFReport(Boolean generatePDFReport) {
        this.generatePDFReport = generatePDFReport;
    }

    public File getZipFile() {
        return this.zipFile;
    }

    public void setZipFile(File zipFile) {
        this.zipFile = zipFile;
    }

    public Integer getEngineConfigurationId() {
        return this.engineConfigurationId;
    }

    public void setEngineConfigurationId(Integer engineConfigurationId) {
        this.engineConfigurationId = engineConfigurationId;
    }

    public String getOsaFilterPattern() {
        return this.osaFilterPattern;
    }

    public String getOsaFolderExclusions() {
        return this.osaFolderExclusions;
    }

    public void setOsaFolderExclusions(String osaFolderExclusions) {
        this.osaFolderExclusions = osaFolderExclusions;
    }

    public void setOsaFilterPattern(String osaFilterPattern) {
        this.osaFilterPattern = osaFilterPattern;
    }

    public String getOsaArchiveIncludePatterns() {
        return this.osaArchiveIncludePatterns;
    }

    public void setOsaArchiveIncludePatterns(String osaArchiveIncludePatterns) {
        this.osaArchiveIncludePatterns = osaArchiveIncludePatterns;
    }

    public Boolean getOsaRunInstall() {
        return this.osaRunInstall;
    }

    public void setOsaRunInstall(Boolean osaRunInstall) {
        this.osaRunInstall = osaRunInstall;
    }

    public Boolean getOsaThresholdsEnabled() {
        return this.osaThresholdsEnabled;
    }

    public void setOsaThresholdsEnabled(Boolean osaThresholdsEnabled) {
        this.osaThresholdsEnabled = osaThresholdsEnabled;
    }

    public Integer getOsaHighThreshold() {
        return this.osaHighThreshold;
    }

    public void setOsaHighThreshold(Integer osaHighThreshold) {
        this.osaHighThreshold = osaHighThreshold;
    }

    public Integer getOsaMediumThreshold() {
        return this.osaMediumThreshold;
    }

    public void setOsaMediumThreshold(Integer osaMediumThreshold) {
        this.osaMediumThreshold = osaMediumThreshold;
    }

    public Integer getOsaLowThreshold() {
        return this.osaLowThreshold;
    }

    public void setOsaLowThreshold(Integer osaLowThreshold) {
        this.osaLowThreshold = osaLowThreshold;
    }

    public Properties getOsaFsaConfig() {
        return this.osaFsaConfig;
    }

    public void setOsaFsaConfig(Properties osaFsaConfig) {
        this.osaFsaConfig = osaFsaConfig;
    }

    public String getOsaDependenciesJson() {
        return this.osaDependenciesJson;
    }

    public boolean isSASTThresholdEffectivelyEnabled() {
        return this.getSastEnabled() != false && this.getSastThresholdsEnabled() != false && (this.getSastHighThreshold() != null || this.getSastMediumThreshold() != null || this.getSastLowThreshold() != null);
    }

    public boolean isOSAThresholdEffectivelyEnabled() {
        return this.getOsaEnabled() != false && this.getOsaThresholdsEnabled() != false && (this.getOsaHighThreshold() != null || this.getOsaMediumThreshold() != null || this.getOsaLowThreshold() != null);
    }

    public void setOsaDependenciesJson(String osaDependenciesJson) {
        this.osaDependenciesJson = osaDependenciesJson;
    }

    public Boolean getOsaGenerateJsonReport() {
        return this.osaGenerateJsonReport;
    }

    public void setOsaGenerateJsonReport(Boolean osaGenerateJsonReport) {
        this.osaGenerateJsonReport = osaGenerateJsonReport;
    }

    public boolean getEnablePolicyViolations() {
        return this.enablePolicyViolations;
    }

    public void setEnablePolicyViolations(boolean enablePolicyViolations) {
        this.enablePolicyViolations = enablePolicyViolations;
    }

    public boolean isEnablePolicyViolations() {
        return this.enablePolicyViolations;
    }

    public String getCxARMUrl() {
        return this.cxARMUrl;
    }

    public void setCxARMUrl(String cxARMUrl) {
        this.cxARMUrl = cxARMUrl;
    }

    public Boolean getHideResults() {
        return this.hideResults;
    }

    public void setHideResults(Boolean hideResults) {
        this.hideResults = hideResults;
    }

    public Boolean isAvoidDuplicateProjectScans() {
        return this.avoidDuplicateProjectScans;
    }

    public void setAvoidDuplicateProjectScans(Boolean avoidDuplicateProjectScans) {
        this.avoidDuplicateProjectScans = avoidDuplicateProjectScans;
    }

    public String getRemoteSrcUser() {
        return this.remoteSrcUser;
    }

    public void setRemoteSrcUser(String remoteSrcUser) {
        this.remoteSrcUser = remoteSrcUser;
    }

    public String getRemoteSrcPass() {
        return this.remoteSrcPass;
    }

    public void setRemoteSrcPass(String remoteSrcPass) {
        this.remoteSrcPass = remoteSrcPass;
    }

    public String getRemoteSrcUrl() {
        return this.remoteSrcUrl;
    }

    public void setRemoteSrcUrl(String remoteSrcUrl) {
        this.remoteSrcUrl = remoteSrcUrl;
    }

    public int getRemoteSrcPort() {
        return this.remoteSrcPort;
    }

    public void setRemoteSrcPort(int remoteSrcPort) {
        this.remoteSrcPort = remoteSrcPort;
    }

    public byte[] getRemoteSrcKeyFile() {
        return this.remoteSrcKeyFile;
    }

    public void setRemoteSrcKeyFile(byte[] remoteSrcKeyFile) {
        this.remoteSrcKeyFile = remoteSrcKeyFile;
    }

    public RemoteSourceTypes getRemoteType() {
        return this.remoteType;
    }

    public void setRemoteType(RemoteSourceTypes remoteType) {
        this.remoteType = remoteType;
    }

    public String[] getPaths() {
        return this.paths;
    }

    public void setPaths(String[] paths) {
        this.paths = paths;
    }

    public String getRemoteSrcBranch() {
        return this.remoteSrcBranch;
    }

    public void setRemoteSrcBranch(String remoteSrcBranch) {
        this.remoteSrcBranch = remoteSrcBranch;
    }

    public String getPreforceMode() {
        return this.preforceMode;
    }

    public void setPreforceMode(String preforceMode) {
        this.preforceMode = preforceMode;
    }

    public Boolean getGenerateXmlReport() {
        return this.generateXmlReport;
    }

    public void setGenerateXmlReport(Boolean generateXmlReport) {
        this.generateXmlReport = generateXmlReport;
    }

    public CxVersion getCxVersion() {
        return this.cxVersion;
    }

    public void setCxVersion(CxVersion cxVersion) {
        this.cxVersion = cxVersion;
    }
}

