/*
 * Decompiled with CFR 0.152.
 */
package com.cx.restclient.httpClient;

import com.cx.restclient.common.UrlUtils;
import com.cx.restclient.dto.TokenLoginResponse;
import com.cx.restclient.exception.CxClientException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.NoConnectionReuseStrategy;
import org.apache.http.impl.auth.BasicSchemeFactory;
import org.apache.http.impl.auth.DigestSchemeFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.ProxyAuthenticationStrategy;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.slf4j.Logger;

public class CxHttpClient {
    private static String HTTP_HOST = System.getProperty("http.proxyHost");
    private static String HTTP_PORT = System.getProperty("http.proxyPort");
    private static String HTTP_USERNAME = System.getProperty("http.proxyUser");
    private static String HTTP_PASSWORD = System.getProperty("http.proxyPassword");
    private static String HTTPS_HOST = System.getProperty("https.proxyHost");
    private static String HTTPS_PORT = System.getProperty("https.proxyPort");
    private static String HTTPS_USERNAME = System.getProperty("https.proxyUser");
    private static String HTTPS_PASSWORD = System.getProperty("https.proxyPassword");
    private static HttpClient apacheClient;
    private Logger logi;
    private TokenLoginResponse token;
    private String rootUri;
    private final String username;
    private final String password;
    private String cxOrigin;

    public CxHttpClient(String hostname, String username, String password, String origin, boolean disableSSLValidation, Logger logi, String proxyHost, int proxyPort, String proxyUser, String proxyPassword) throws MalformedURLException, CxClientException {
        this.logi = logi;
        this.username = username;
        this.password = password;
        this.rootUri = UrlUtils.parseURLToString(hostname, "CxRestAPI/");
        this.cxOrigin = origin;
        HttpClientBuilder cb = HttpClients.custom();
        cb.setDefaultRequestConfig(RequestConfig.custom().setCookieSpec("standard").build());
        this.setSSLTls(cb, "TLSv1.2", logi);
        if (disableSSLValidation) {
            try {
                cb.setSSLSocketFactory((LayeredConnectionSocketFactory)CxHttpClient.getSSLSF());
                cb.setConnectionManager((HttpClientConnectionManager)CxHttpClient.getHttpConnManager(true));
            }
            catch (CxClientException e) {
                logi.warn("Failed to disable certificate verification: " + e.getMessage());
            }
        } else {
            cb.setConnectionManager((HttpClientConnectionManager)CxHttpClient.getHttpConnManager(false));
        }
        cb.setConnectionManagerShared(true);
        if (proxyHost != null) {
            CxHttpClient.setCustomProxy(cb, proxyHost, proxyPort, proxyUser, proxyPassword, logi);
        } else {
            CxHttpClient.setProxy(cb, logi);
        }
        cb.setConnectionReuseStrategy((ConnectionReuseStrategy)new NoConnectionReuseStrategy());
        cb.setDefaultAuthSchemeRegistry(CxHttpClient.getAuthSchemeProviderRegistry());
        cb.useSystemProperties();
        apacheClient = cb.build();
    }

    public CxHttpClient(String hostname, String username, String password, String origin, boolean disableSSLValidation, Logger logi) throws MalformedURLException, CxClientException {
        this(hostname, username, password, origin, disableSSLValidation, logi, null, 0, null, null);
    }

    private static void setCustomProxy(HttpClientBuilder cb, String proxyHost, int proxyPort, String proxyUser, String proxyPassword, Logger logi) {
        HttpHost proxy = null;
        if (!StringUtils.isEmpty((CharSequence)proxyHost)) {
            proxy = new HttpHost(proxyHost, proxyPort, "http");
            if (!StringUtils.isEmpty((CharSequence)proxyUser) && !StringUtils.isEmpty((CharSequence)proxyPassword)) {
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(proxy), (Credentials)new UsernamePasswordCredentials(proxyUser, proxyPassword));
                cb.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
            }
        }
        if (proxy != null) {
            logi.info("Setting proxy for Checkmarx http client");
            cb.setProxy(proxy);
            cb.setRoutePlanner((HttpRoutePlanner)new DefaultProxyRoutePlanner(proxy));
            cb.setProxyAuthenticationStrategy((AuthenticationStrategy)new ProxyAuthenticationStrategy());
        }
    }

    private static void setProxy(HttpClientBuilder cb, Logger logi) {
        HttpHost proxyHost = null;
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        if (!StringUtils.isEmpty((CharSequence)HTTPS_HOST) && !StringUtils.isEmpty((CharSequence)HTTPS_PORT)) {
            proxyHost = new HttpHost(HTTPS_HOST, Integer.parseInt(HTTPS_PORT), "https");
            if (!StringUtils.isEmpty((CharSequence)HTTPS_USERNAME) && !StringUtils.isEmpty((CharSequence)HTTPS_PASSWORD)) {
                credsProvider.setCredentials(new AuthScope(HTTPS_HOST, Integer.parseInt(HTTPS_PORT)), (Credentials)new UsernamePasswordCredentials(HTTPS_USERNAME, HTTPS_PASSWORD));
                cb.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
            }
        } else if (!StringUtils.isEmpty((CharSequence)HTTP_HOST) && !StringUtils.isEmpty((CharSequence)HTTP_PORT)) {
            proxyHost = new HttpHost(HTTP_HOST, Integer.parseInt(HTTP_PORT), "http");
            if (!StringUtils.isEmpty((CharSequence)HTTP_USERNAME) && !StringUtils.isEmpty((CharSequence)HTTP_PASSWORD)) {
                credsProvider.setCredentials(new AuthScope(HTTP_HOST, Integer.parseInt(HTTP_PORT)), (Credentials)new UsernamePasswordCredentials(HTTP_USERNAME, HTTP_PASSWORD));
                cb.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
            }
        }
        if (proxyHost != null) {
            logi.info("Setting proxy for Checkmarx http client");
            cb.setRoutePlanner((HttpRoutePlanner)new DefaultProxyRoutePlanner(proxyHost));
            cb.setProxy(proxyHost);
            cb.setProxyAuthenticationStrategy((AuthenticationStrategy)new ProxyAuthenticationStrategy());
        }
    }

    private static SSLConnectionSocketFactory getSSLSF() throws CxClientException {
        SSLContext sslContext;
        TrustAllStrategy acceptingTrustStrategy = new TrustAllStrategy();
        try {
            sslContext = SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)acceptingTrustStrategy).build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new CxClientException("Fail to set trust all certificate, 'SSLConnectionSocketFactory'", e);
        }
        return new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
    }

    private static PoolingHttpClientConnectionManager getHttpConnManager(boolean disableSSLValidation) throws CxClientException {
        SSLConnectionSocketFactory sslConnectionFactory = disableSSLValidation ? CxHttpClient.getSSLSF() : new SSLConnectionSocketFactory(SSLContexts.createDefault());
        Registry socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)sslConnectionFactory).register("http", (Object)new PlainConnectionSocketFactory()).build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        connManager.setMaxTotal(50);
        connManager.setDefaultMaxPerRoute(5);
        return connManager;
    }

    private static Registry<AuthSchemeProvider> getAuthSchemeProviderRegistry() {
        return RegistryBuilder.create().register("Digest", (Object)new DigestSchemeFactory()).register("Basic", (Object)new BasicSchemeFactory()).build();
    }

    public void login() throws IOException, CxClientException {
        UrlEncodedFormEntity requestEntity = this.generateUrlEncodedFormEntity(" cxarm_api");
        HttpPost post = new HttpPost(this.rootUri + "auth/identity/connect/token");
        try {
            this.token = this.request((HttpRequestBase)post, ContentType.APPLICATION_FORM_URLENCODED.toString(), (HttpEntity)requestEntity, TokenLoginResponse.class, 200, "authenticate", false, false);
        }
        catch (CxClientException e) {
            if (!e.getMessage().contains("invalid_scope")) {
                throw e;
            }
            requestEntity = this.generateUrlEncodedFormEntity("");
            this.token = this.request((HttpRequestBase)post, ContentType.APPLICATION_FORM_URLENCODED.toString(), (HttpEntity)requestEntity, TokenLoginResponse.class, 200, "authenticate", false, false);
        }
    }

    private UrlEncodedFormEntity generateUrlEncodedFormEntity(String armScope) throws UnsupportedEncodingException {
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        parameters.add(new BasicNameValuePair("username", this.username));
        parameters.add(new BasicNameValuePair("password", this.password));
        parameters.add(new BasicNameValuePair("grant_type", "password"));
        parameters.add(new BasicNameValuePair("scope", "sast_rest_api" + armScope));
        parameters.add(new BasicNameValuePair("client_id", "resource_owner_client"));
        parameters.add(new BasicNameValuePair("client_secret", "014DF517-39D1-4453-B7B3-9930C563627C"));
        return new UrlEncodedFormEntity(parameters, "utf-8");
    }

    public <T> T getRequest(String relPath, String contentType, Class<T> responseType, int expectStatus, String failedMsg, boolean isCollection) throws IOException, CxClientException {
        return this.getRequest(this.rootUri, relPath, "application/json", contentType, responseType, expectStatus, failedMsg, isCollection);
    }

    public <T> T getRequest(String rootURL, String relPath, String acceptHeader, String contentType, Class<T> responseType, int expectStatus, String failedMsg, boolean isCollection) throws IOException, CxClientException {
        HttpGet get = new HttpGet(rootURL + relPath);
        get.addHeader("Accept", acceptHeader);
        return this.request((HttpRequestBase)get, contentType, null, responseType, expectStatus, "get " + failedMsg, isCollection, true);
    }

    public <T> T postRequest(String relPath, String contentType, HttpEntity entity, Class<T> responseType, int expectStatus, String failedMsg) throws IOException, CxClientException {
        HttpPost post = new HttpPost(this.rootUri + relPath);
        return this.request((HttpRequestBase)post, contentType, entity, responseType, expectStatus, failedMsg, false, true);
    }

    public <T> T putRequest(String relPath, String contentType, HttpEntity entity, Class<T> responseType, int expectStatus, String failedMsg) throws IOException, CxClientException {
        HttpPut put = new HttpPut(this.rootUri + relPath);
        return this.request((HttpRequestBase)put, contentType, entity, responseType, expectStatus, failedMsg, false, true);
    }

    public void patchRequest(String relPath, String contentType, HttpEntity entity, int expectStatus, String failedMsg) throws IOException, CxClientException {
        HttpPatch patch = new HttpPatch(this.rootUri + relPath);
        this.request((HttpRequestBase)patch, contentType, entity, null, expectStatus, failedMsg, false, true);
    }

    /*
     * Exception decompiling
     */
    private <T> T request(HttpRequestBase httpMethod, String contentType, HttpEntity entity, Class<T> responseType, int expectStatus, String failedMsg, boolean isCollection, boolean retry) throws IOException, CxClientException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void close() {
        HttpClientUtils.closeQuietly((HttpClient)apacheClient);
    }

    private void setSSLTls(HttpClientBuilder builder, String protocol, Logger log) {
        SSLContext sslContext = null;
        try {
            sslContext = SSLContextBuilder.create().useProtocol(protocol).build();
            builder.setSSLContext(sslContext);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            log.warn("Failed to set SSL TLS : " + e.getMessage());
        }
    }
}

