/*
 * Decompiled with CFR 0.152.
 */
package com.cx.restclient.httpClient.utils;

import com.cx.restclient.exception.CxClientException;
import com.cx.restclient.exception.CxHTTPClientException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;

public abstract class HttpClientHelper {
    public static <T> T convertToObject(HttpResponse response, Class<T> responseType, boolean isCollection) throws IOException, CxClientException {
        if (responseType == null || response.getEntity() == null || response.getEntity().getContentLength() == 0L) {
            return null;
        }
        if (responseType.equals(byte[].class)) {
            return (T)IOUtils.toByteArray((InputStream)response.getEntity().getContent());
        }
        if (isCollection) {
            return HttpClientHelper.convertToCollectionObject(response, (JavaType)TypeFactory.defaultInstance().constructCollectionType(List.class, responseType));
        }
        return HttpClientHelper.convertToStrObject(response, responseType);
    }

    private static <T> T convertToStrObject(HttpResponse response, Class<T> valueType) throws CxClientException {
        ObjectMapper mapper = new ObjectMapper();
        try {
            if (response.getEntity() == null) {
                return null;
            }
            String json = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)Charset.defaultCharset());
            return (T)mapper.readValue(json, valueType);
        }
        catch (IOException e) {
            throw new CxClientException("Failed to parse json response: " + e.getMessage());
        }
    }

    public static String convertToJson(Object o) throws CxClientException {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString(o);
        }
        catch (Exception e) {
            throw new CxClientException("Failed convert object to json: " + e.getMessage());
        }
    }

    private static <T> T convertToCollectionObject(HttpResponse response, JavaType javaType) throws CxClientException {
        ObjectMapper mapper = new ObjectMapper();
        try {
            String json = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)Charset.defaultCharset());
            return (T)mapper.readValue(json, javaType);
        }
        catch (IOException e) {
            throw new CxClientException("Failed to parse json response: " + e.getMessage(), e);
        }
    }

    public static void validateResponse(HttpResponse response, int status, String message) throws CxClientException {
        if (response.getStatusLine().getStatusCode() != status) {
            String responseBody = HttpClientHelper.extractResponseBody(response);
            responseBody = responseBody.replace("{", "").replace("}", "").replace(System.getProperty("line.separator"), " ").replace("  ", "");
            throw new CxHTTPClientException(response.getStatusLine().getStatusCode(), message + ": " + responseBody);
        }
    }

    public static String extractResponseBody(HttpResponse response) {
        try {
            return IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)Charset.defaultCharset());
        }
        catch (Exception e) {
            return "";
        }
    }
}

