/*
 * Decompiled with CFR 0.152.
 */
package com.cx.restclient.sast.utils.zip;

import com.cx.restclient.sast.utils.zip.ZipListener;
import com.cx.restclient.sast.utils.zip.Zipper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;

public class CxZip {
    private long maxZipSizeInBytes = 0x80000000L;
    private int numOfZippedFiles = 0;
    private String tempFileName;
    private Logger log;

    public CxZip(String tempFileName, long maxZipSizeInBytes, Logger log) {
        this.tempFileName = tempFileName;
        this.log = log;
        this.maxZipSizeInBytes = maxZipSizeInBytes;
    }

    public File zipWorkspaceFolder(File baseDir, String[] includes, String[] excludes) throws IOException {
        this.log.info("Zipping workspace: '" + baseDir + "'");
        ZipListener zipListener = new ZipListener(){

            @Override
            public void updateProgress(String fileName, long size) {
                CxZip.this.numOfZippedFiles++;
                CxZip.this.log.info("Zipping (" + FileUtils.byteCountToDisplaySize((long)size) + "): " + fileName);
            }
        };
        File tempFile = File.createTempFile(this.tempFileName, ".bin");
        FileOutputStream fileOutputStream = new FileOutputStream(tempFile);
        try {
            new Zipper(this.log).zip(baseDir, includes, excludes, fileOutputStream, this.maxZipSizeInBytes, zipListener);
        }
        catch (Zipper.MaxZipSizeReached e) {
            tempFile.delete();
            throw new IOException("Reached maximum upload size limit of " + FileUtils.byteCountToDisplaySize((long)this.maxZipSizeInBytes));
        }
        catch (Zipper.NoFilesToZip e) {
            throw new IOException("No files to zip");
        }
        this.log.info("Zipping complete with " + this.numOfZippedFiles + " files, total compressed size: " + FileUtils.byteCountToDisplaySize((long)tempFile.length()));
        this.log.info("Temporary file with zipped sources was created at: '" + tempFile.getAbsolutePath() + "'");
        return tempFile;
    }

    public CxZip setMaxZipSizeInBytes(long maxZipSizeInBytes) {
        this.maxZipSizeInBytes = maxZipSizeInBytes;
        return this;
    }

    public CxZip setTempFileName(String tempFileName) {
        this.tempFileName = tempFileName;
        return this;
    }

    public String getTempFileName() {
        return this.tempFileName;
    }
}

