/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.dependency.resolver;

import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whitesource.agent.api.model.AgentProjectInfo;
import org.whitesource.agent.api.model.DependencyType;
import org.whitesource.agent.dependency.resolver.AbstractDependencyResolver;
import org.whitesource.agent.dependency.resolver.ResolutionResult;
import org.whitesource.agent.dependency.resolver.ResolvedFolder;
import org.whitesource.agent.dependency.resolver.bower.BowerDependencyResolver;
import org.whitesource.agent.dependency.resolver.dotNet.DotNetDependencyResolver;
import org.whitesource.agent.dependency.resolver.go.GoDependencyResolver;
import org.whitesource.agent.dependency.resolver.gradle.GradleDependencyResolver;
import org.whitesource.agent.dependency.resolver.html.HtmlDependencyResolver;
import org.whitesource.agent.dependency.resolver.maven.MavenDependencyResolver;
import org.whitesource.agent.dependency.resolver.npm.NpmDependencyResolver;
import org.whitesource.agent.dependency.resolver.nuget.NugetDependencyResolver;
import org.whitesource.agent.dependency.resolver.nuget.packagesConfig.NugetConfigFileType;
import org.whitesource.agent.dependency.resolver.paket.PaketDependencyResolver;
import org.whitesource.agent.dependency.resolver.php.PhpDependencyResolver;
import org.whitesource.agent.dependency.resolver.python.PythonDependencyResolver;
import org.whitesource.agent.dependency.resolver.ruby.RubyDependencyResolver;
import org.whitesource.agent.dependency.resolver.sbt.SbtDependencyResolver;
import org.whitesource.agent.utils.FilesScanner;
import org.whitesource.fs.configuration.ResolverConfiguration;

public class DependencyResolutionService {
    private final Logger logger = LoggerFactory.getLogger(DependencyResolutionService.class);
    private final FilesScanner fileScanner;
    private final Collection<AbstractDependencyResolver> dependencyResolvers;
    private final boolean dependenciesOnly;
    private boolean separateProjects;
    private boolean mavenAggregateModules;
    private boolean sbtAggregateModules;
    private boolean gradleAggregateModules;
    public static final List<DependencyType> multiModuleDependencyTypes = Arrays.asList(DependencyType.MAVEN, DependencyType.GRADLE);

    public DependencyResolutionService(ResolverConfiguration config) {
        boolean npmRunPreStep = config.isNpmRunPreStep();
        boolean npmIgnoreScripts = config.isNpmIgnoreScripts();
        boolean npmResolveDependencies = config.isNpmResolveDependencies();
        boolean npmIncludeDevDependencies = config.isNpmIncludeDevDependencies();
        boolean npmIgnoreJavaScriptFiles = config.isNpmIgnoreJavaScriptFiles();
        long npmTimeoutDependenciesCollector = config.getNpmTimeoutDependenciesCollector();
        boolean npmIgnoreNpmLsErrors = config.getNpmIgnoreNpmLsErrors();
        String npmAccessToken = config.getNpmAccessToken();
        boolean npmYarnProject = config.getNpmYarnProject();
        boolean bowerResolveDependencies = config.isBowerResolveDependencies();
        boolean bowerRunPreStep = config.isBowerRunPreStep();
        boolean nugetResolveDependencies = config.isNugetResolveDependencies();
        boolean nugetRestoreDependencies = config.isNugetRestoreDependencies();
        boolean mavenResolveDependencies = config.isMavenResolveDependencies();
        String[] mavenIgnoredScopes = config.getMavenIgnoredScopes();
        boolean mavenAggregateModules = config.isMavenAggregateModules();
        boolean mavenIgnorePomModules = config.isMavenIgnorePomModules();
        boolean pythonResolveDependencies = config.isPythonResolveDependencies();
        String[] pythonRequirementsFileIncludes = config.getPythonRequirementsFileIncludes();
        boolean gradleResolveDependencies = config.isGradleResolveDependencies();
        boolean gradleAggregateModules = config.isGradleAggregateModules();
        boolean paketResolveDependencies = config.isPaketResolveDependencies();
        String[] paketIgnoredScopes = config.getPaketIgnoredScopes();
        boolean paketIgnoreFiles = config.getPaketIgnoreFiles();
        boolean paketRunPreStep = config.isPaketRunPreStep();
        String paketPath = config.getPaketPath();
        boolean goResolveDependencies = config.isGoResolveDependencies();
        boolean rubyResolveDependencies = config.isRubyResolveDependencies();
        boolean rubyRunBundleInstall = config.isRubyRunBundleInstall();
        boolean rubyOverwriteGemFile = config.isRubyOverwriteGemFile();
        boolean rubyInstallMissingGems = config.isRubyInstallMissingGems();
        boolean phpResolveDependencies = config.isPhpResolveDependencies();
        boolean phpRunPreStep = config.isPhpRunPreStep();
        boolean phpIncludeDevDependencies = config.isPhpIncludeDevDependencies();
        boolean sbtResolveDependencies = config.isSbtResolveDependencies();
        boolean sbtAggregateModules = config.isSbtAggregateModules();
        boolean sbtRunPreStep = config.isSbtRunPreStep();
        String sbtTargetFolder = config.getSbtTargetFolder();
        boolean htmlResolveDependencies = config.isHtmlResolveDependencies();
        this.dependenciesOnly = config.isDependenciesOnly();
        this.fileScanner = new FilesScanner();
        this.dependencyResolvers = new ArrayList<AbstractDependencyResolver>();
        if (npmResolveDependencies) {
            this.dependencyResolvers.add(new NpmDependencyResolver(npmIncludeDevDependencies, npmIgnoreJavaScriptFiles, npmTimeoutDependenciesCollector, npmRunPreStep, npmIgnoreNpmLsErrors, npmAccessToken, npmYarnProject, npmIgnoreScripts));
        }
        if (bowerResolveDependencies) {
            this.dependencyResolvers.add(new BowerDependencyResolver(npmTimeoutDependenciesCollector, bowerRunPreStep));
        }
        if (nugetResolveDependencies) {
            String whitesourceConfiguration = config.getWhitesourceConfiguration();
            this.dependencyResolvers.add(new NugetDependencyResolver(whitesourceConfiguration, NugetConfigFileType.CONFIG_FILE_TYPE));
            this.dependencyResolvers.add(new DotNetDependencyResolver(whitesourceConfiguration, NugetConfigFileType.CSPROJ_TYPE, nugetRestoreDependencies));
        }
        if (mavenResolveDependencies) {
            this.dependencyResolvers.add(new MavenDependencyResolver(mavenAggregateModules, mavenIgnoredScopes, this.dependenciesOnly, mavenIgnorePomModules));
            this.mavenAggregateModules = mavenAggregateModules;
        }
        if (pythonResolveDependencies) {
            this.dependencyResolvers.add(new PythonDependencyResolver(config.getPythonPath(), config.getPipPath(), config.isPythonIgnorePipInstallErrors(), config.isPythonInstallVirtualenv(), config.isPythonResolveHierarchyTree(), pythonRequirementsFileIncludes));
        }
        if (gradleResolveDependencies) {
            this.dependencyResolvers.add(new GradleDependencyResolver(config.isGradleRunAssembleCommand(), this.dependenciesOnly, gradleAggregateModules));
            this.gradleAggregateModules = gradleAggregateModules;
        }
        if (paketResolveDependencies) {
            this.dependencyResolvers.add(new PaketDependencyResolver(paketIgnoredScopes, paketIgnoreFiles, paketRunPreStep, paketPath));
        }
        if (goResolveDependencies) {
            this.dependencyResolvers.add(new GoDependencyResolver(config.getGoDependencyManager(), config.isGoCollectDependenciesAtRuntime(), config.isDependenciesOnly()));
        }
        if (rubyResolveDependencies) {
            this.dependencyResolvers.add(new RubyDependencyResolver(rubyRunBundleInstall, rubyOverwriteGemFile, rubyInstallMissingGems));
        }
        if (phpResolveDependencies) {
            this.dependencyResolvers.add(new PhpDependencyResolver(phpRunPreStep, phpIncludeDevDependencies));
        }
        if (htmlResolveDependencies) {
            this.dependencyResolvers.add(new HtmlDependencyResolver());
        }
        if (sbtResolveDependencies) {
            this.dependencyResolvers.add(new SbtDependencyResolver(sbtAggregateModules, this.dependenciesOnly, sbtRunPreStep, sbtTargetFolder));
            this.sbtAggregateModules = sbtAggregateModules;
        }
        this.separateProjects = false;
    }

    public boolean isMavenAggregateModules() {
        return this.mavenAggregateModules;
    }

    public boolean isSbtAggregateModules() {
        return this.sbtAggregateModules;
    }

    public boolean isGradleAggregateModules() {
        return this.gradleAggregateModules;
    }

    public boolean isSeparateProjects() {
        return this.separateProjects;
    }

    public boolean isDependenciesOnly() {
        return this.dependenciesOnly;
    }

    public boolean shouldResolveDependencies(Set<String> allFoundFiles) {
        for (AbstractDependencyResolver dependencyResolver : this.dependencyResolvers) {
            for (String fileExtension : dependencyResolver.getSourceFileExtensions()) {
                boolean shouldResolve = allFoundFiles.stream().filter(file -> file.endsWith(fileExtension)).findAny().isPresent();
                if (!shouldResolve) continue;
                return true;
            }
        }
        return false;
    }

    public List<ResolutionResult> resolveDependencies(Collection<String> pathsToScan, String[] excludes) {
        HashMap<ResolvedFolder, AbstractDependencyResolver> topFolderResolverMap = new HashMap<ResolvedFolder, AbstractDependencyResolver>();
        LinkedList<ResolutionResult> multiModuleResults = new LinkedList<ResolutionResult>();
        LinkedList<ResolutionResult> htmlResults = new LinkedList<ResolutionResult>();
        this.dependencyResolvers.forEach(dependencyResolver -> {
            LinkedList<String> combinedExcludes = new LinkedList<String>(Arrays.asList(excludes));
            Collection<String> resolverExcludes = dependencyResolver.getExcludes();
            for (String exclude : resolverExcludes) {
                combinedExcludes.add(exclude);
            }
            this.logger.debug("Attempting to find the top folders of {} with pattern {}", (Object)pathsToScan, (Object)dependencyResolver.getBomPattern());
            Collection<ResolvedFolder> topFolders = this.fileScanner.findTopFolders(pathsToScan, dependencyResolver.getBomPattern(), combinedExcludes);
            topFolders.forEach(topFolder -> topFolderResolverMap.put((ResolvedFolder)topFolder, (AbstractDependencyResolver)dependencyResolver));
        });
        this.logger.debug("Attempting to reduce dependencies");
        this.reduceDependencies(topFolderResolverMap);
        this.logger.debug("Finishing reduce dependencies");
        ArrayList<ResolutionResult> resolutionResults = new ArrayList<ResolutionResult>();
        topFolderResolverMap.forEach((resolvedFolder, dependencyResolver) -> {
            if (!resolvedFolder.getTopFoldersFound().isEmpty()) {
                this.logger.info("Trying to resolve " + dependencyResolver.getDependencyTypeName() + " dependencies");
            }
            resolvedFolder.getTopFoldersFound().forEach((topFolder, bomFiles) -> {
                if (dependencyResolver.printResolvedFolder()) {
                    this.logger.info("topFolder = " + topFolder);
                }
                this.logger.debug("topFolder = " + topFolder);
                ResolutionResult result = null;
                try {
                    result = dependencyResolver.resolveDependencies(resolvedFolder.getOriginalScanFolder(), (String)topFolder, (Set<String>)bomFiles);
                }
                catch (FileNotFoundException e) {
                    this.logger.error(e.getMessage());
                }
                resolutionResults.add(result);
                if (multiModuleDependencyTypes.contains(dependencyResolver.getDependencyType())) {
                    multiModuleResults.add(result);
                } else if ("html".toUpperCase().equals(dependencyResolver.getDependencyTypeName())) {
                    htmlResults.add(result);
                }
            });
        });
        this.findAndSetHtmlProject(multiModuleResults, htmlResults, resolutionResults);
        return resolutionResults;
    }

    private void findAndSetHtmlProject(Collection<ResolutionResult> multiModuleResults, Collection<ResolutionResult> htmlResults, Collection<ResolutionResult> resolutionResults) {
        if (!multiModuleResults.isEmpty() || !htmlResults.isEmpty()) {
            HashMap<AgentProjectInfo, ResolutionResult> agentProjectInfoToResolutionResult = new HashMap<AgentProjectInfo, ResolutionResult>();
            Map<AgentProjectInfo, Path> multiModuleProjects = this.generateMultiProjectMap(multiModuleResults, agentProjectInfoToResolutionResult);
            Map<AgentProjectInfo, Path> htmlProjects = this.generateMultiProjectMap(htmlResults, agentProjectInfoToResolutionResult);
            for (Map.Entry<AgentProjectInfo, Path> multiModuleProject : multiModuleProjects.entrySet()) {
                for (Map.Entry<AgentProjectInfo, Path> htmlProject : htmlProjects.entrySet()) {
                    if (!htmlProject.getValue().toAbsolutePath().toString().contains(multiModuleProject.getValue().toAbsolutePath().toString())) continue;
                    ResolutionResult htmlResult = (ResolutionResult)agentProjectInfoToResolutionResult.get(htmlProject.getKey());
                    resolutionResults.remove(htmlResult);
                    multiModuleProject.getKey().getDependencies().addAll(htmlProject.getKey().getDependencies());
                    ResolutionResult multiModuleResult = (ResolutionResult)agentProjectInfoToResolutionResult.get(htmlProject.getKey());
                    multiModuleResult.getResolvedProjects().put(multiModuleProject.getKey(), multiModuleProject.getValue());
                }
            }
        }
    }

    private Map<AgentProjectInfo, Path> generateMultiProjectMap(Collection<ResolutionResult> projectResults, Map<AgentProjectInfo, ResolutionResult> agentProjectInfoToResolutionResult) {
        HashMap<AgentProjectInfo, Path> resolvedProjects = new HashMap<AgentProjectInfo, Path>();
        for (ResolutionResult result : projectResults) {
            Map<AgentProjectInfo, Path> projects = result.getResolvedProjects();
            for (Map.Entry<AgentProjectInfo, Path> project : projects.entrySet()) {
                agentProjectInfoToResolutionResult.put(project.getKey(), result);
            }
            resolvedProjects.putAll(projects);
        }
        return resolvedProjects;
    }

    public Collection<AbstractDependencyResolver> getDependencyResolvers() {
        return this.dependencyResolvers;
    }

    private void reduceDependencies(Map<ResolvedFolder, AbstractDependencyResolver> topFolderResolverMap) {
        HashSet topFolders = new HashSet();
        topFolderResolverMap.entrySet().forEach(resolverEntry -> topFolders.addAll(((ResolvedFolder)resolverEntry.getKey()).getTopFoldersFound().keySet()));
        topFolders.stream().sorted().forEach(topFolderParent -> topFolderResolverMap.forEach((resolvedFolder, dependencyResolver) -> {
            if (!(dependencyResolver instanceof HtmlDependencyResolver)) {
                resolvedFolder.getTopFoldersFound().entrySet().removeIf(topFolderChild -> this.isChildFolder((String)topFolderChild.getKey(), (String)topFolderParent));
            }
        }));
    }

    private boolean isChildFolder(String childFolder, String topFolderParent) {
        boolean result = childFolder.contains(topFolderParent) && !childFolder.equals(topFolderParent);
        return result;
    }
}

