/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.dependency.resolver.dotNet;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import java.util.stream.Collectors;
import org.whitesource.agent.api.model.AgentProjectInfo;
import org.whitesource.agent.dependency.resolver.ResolutionResult;
import org.whitesource.agent.dependency.resolver.dotNet.DotNetRestoreCollector;
import org.whitesource.agent.dependency.resolver.nuget.NugetDependencyResolver;
import org.whitesource.agent.dependency.resolver.nuget.packagesConfig.NugetConfigFileType;

public class DotNetDependencyResolver
extends NugetDependencyResolver {
    private final DotNetRestoreCollector resolveCollector;
    private boolean nugetRestoreDependencies;

    public DotNetDependencyResolver(String whitesourceConfiguration, NugetConfigFileType nugetConfigFileType, boolean nugetRestoreDependencies) {
        super(whitesourceConfiguration, nugetConfigFileType);
        this.nugetRestoreDependencies = nugetRestoreDependencies;
        this.resolveCollector = new DotNetRestoreCollector();
    }

    @Override
    protected ResolutionResult resolveDependencies(String projectFolder, String topLevelFolder, Set<String> csprojFiles) {
        if (this.nugetRestoreDependencies) {
            this.resolveCollector.executeDotNetRestore(projectFolder, csprojFiles);
            Collection<AgentProjectInfo> projects = this.resolveCollector.collectDependencies(projectFolder);
            Collection dependencies = projects.stream().flatMap(project -> project.getDependencies().stream()).collect(Collectors.toList());
            dependencies.addAll(this.parseNugetPackageFiles(csprojFiles, true));
            return new ResolutionResult(dependencies, new LinkedList<String>(), this.getDependencyType(), topLevelFolder);
        }
        return this.getResolutionResultFromParsing(topLevelFolder, csprojFiles, false);
    }
}

