/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.dependency.resolver.html;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.validator.routines.UrlValidator;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.whitesource.agent.DependencyInfoFactory;
import org.whitesource.agent.api.model.DependencyInfo;
import org.whitesource.agent.api.model.DependencyType;
import org.whitesource.agent.dependency.resolver.AbstractDependencyResolver;
import org.whitesource.agent.dependency.resolver.ResolutionResult;
import org.whitesource.agent.utils.FilesUtils;

public class HtmlDependencyResolver
extends AbstractDependencyResolver {
    private final Logger logger = LoggerFactory.getLogger(HtmlDependencyResolver.class);
    public static final List<String> htmlTypeExtensions = Arrays.asList("htm", "html", "shtml", "xhtml", "jsp", "asp", "do", "aspx");
    public final String[] includesPattern = new String[htmlTypeExtensions.size()];
    public static final String WHITESOURCE_HTML_RESOLVER = "whitesource-html-resolver";
    public static final String URL_PATH = "://";
    private final Pattern patternOfFirstLetter = Pattern.compile("[a-zA-Z].*");
    private final Pattern patternOfLegitSrcUrl = Pattern.compile("<%.*%>");

    public HtmlDependencyResolver() {
        int i = 0;
        for (String extension : htmlTypeExtensions) {
            this.includesPattern[i++] = "**/*." + extension;
        }
    }

    @Override
    protected ResolutionResult resolveDependencies(String projectFolder, String topLevelFolder, Set<String> bomFiles) {
        LinkedList<DependencyInfo> dependencies = new LinkedList<DependencyInfo>();
        for (String htmlFile : bomFiles) {
            try {
                Document htmlFileDocument = Jsoup.parse((File)new File(htmlFile), (String)"UTF-8");
                Elements script = htmlFileDocument.getElementsByAttribute("src");
                LinkedList<String> scriptUrls = new LinkedList<String>();
                for (Element srcLink : script) {
                    String srcUrl;
                    String src = srcLink.attr("src");
                    if (src == null || !this.isLegitSrcUrl(src) || (srcUrl = this.fixUrls(src)) == null) continue;
                    scriptUrls.add(srcUrl);
                }
                dependencies.addAll(this.collectJsFilesAndCalcHashes(scriptUrls, htmlFile));
            }
            catch (IOException e) {
                this.logger.debug("Cannot parse the html file: {}", (Object)htmlFile);
            }
        }
        return new ResolutionResult(dependencies, this.getExcludes(), this.getDependencyType(), topLevelFolder);
    }

    private boolean isLegitSrcUrl(String srcUrl) {
        Matcher matcher;
        if (srcUrl.contains("?")) {
            String[] srcURLSplit = srcUrl.split("\\?");
            srcUrl = srcURLSplit[0];
        }
        return srcUrl.endsWith(".js") && !(matcher = this.patternOfLegitSrcUrl.matcher(srcUrl)).find();
    }

    private List<DependencyInfo> collectJsFilesAndCalcHashes(List<String> scriptUrls, String htmlFilePath) {
        LinkedList<DependencyInfo> dependencies = new LinkedList<DependencyInfo>();
        String tempFolder = new FilesUtils().createTmpFolder(false, WHITESOURCE_HTML_RESOLVER);
        File tempFolderFile = new File(tempFolder);
        RestTemplate restTemplate = new RestTemplate();
        String dependencyFileName = null;
        if (tempFolder != null) {
            for (String scriptUrl : scriptUrls) {
                try {
                    URI uriScopeDep = new URI(scriptUrl);
                    HttpHeaders httpHeaders = new HttpHeaders();
                    HttpEntity entity = new HttpEntity((MultiValueMap)httpHeaders);
                    String body = (String)restTemplate.exchange(uriScopeDep, HttpMethod.GET, entity, String.class).getBody();
                    String fileName = scriptUrl.substring(scriptUrl.lastIndexOf("/") + 1);
                    dependencyFileName = tempFolder + File.separator + fileName;
                    PrintWriter writer = new PrintWriter(dependencyFileName, "UTF-8");
                    writer.println(body);
                    writer.close();
                    DependencyInfoFactory dependencyInfoFactory = new DependencyInfoFactory();
                    DependencyInfo dependencyInfo = dependencyInfoFactory.createDependencyInfo(tempFolderFile, fileName);
                    if (dependencyInfo == null) continue;
                    dependencies.add(dependencyInfo);
                    dependencyInfo.setSystemPath(htmlFilePath);
                }
                catch (RestClientException e) {
                    this.logger.debug("Could not reach the registry using the URL: {}. Got an error: {}", (Object)scriptUrl, (Object)e.getMessage());
                }
                catch (URISyntaxException e) {
                    this.logger.debug("Failed creating uri of {}", (Object)scriptUrl);
                }
                catch (IOException e) {
                    this.logger.debug("Failed writing to file {}", dependencyFileName);
                }
            }
            FilesUtils.deleteDirectory(tempFolderFile);
        }
        return dependencies;
    }

    private String fixUrls(String scriptUrl) {
        UrlValidator validator = new UrlValidator();
        if (validator.isValid(scriptUrl)) {
            return scriptUrl;
        }
        Matcher matcher = this.patternOfFirstLetter.matcher(scriptUrl);
        matcher.find();
        if (matcher.group(0) != null) {
            return "http://" + matcher.group(0);
        }
        return null;
    }

    @Override
    protected Collection<String> getExcludes() {
        return new ArrayList<String>();
    }

    @Override
    public Collection<String> getSourceFileExtensions() {
        return htmlTypeExtensions;
    }

    @Override
    protected DependencyType getDependencyType() {
        return null;
    }

    @Override
    protected String getDependencyTypeName() {
        return "html".toUpperCase();
    }

    @Override
    protected boolean printResolvedFolder() {
        return false;
    }

    @Override
    protected String[] getBomPattern() {
        return this.includesPattern;
    }

    @Override
    protected Collection<String> getLanguageExcludes() {
        return new ArrayList<String>();
    }
}

