/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.dependency.resolver.nuget.packagesConfig;

import java.io.File;
import java.io.Serializable;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.simpleframework.xml.core.Persister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whitesource.agent.DependencyInfoFactory;
import org.whitesource.agent.api.model.DependencyInfo;
import org.whitesource.agent.api.model.DependencyType;
import org.whitesource.agent.dependency.resolver.nuget.packagesConfig.NugetConfigFileType;
import org.whitesource.agent.dependency.resolver.nuget.packagesConfig.NugetCsprojItemGroup;
import org.whitesource.agent.dependency.resolver.nuget.packagesConfig.NugetCsprojPackages;
import org.whitesource.agent.dependency.resolver.nuget.packagesConfig.NugetPackage;
import org.whitesource.agent.dependency.resolver.nuget.packagesConfig.NugetPackages;
import org.whitesource.agent.dependency.resolver.nuget.packagesConfig.PackageReference;
import org.whitesource.agent.dependency.resolver.nuget.packagesConfig.ReferenceTag;

public class NugetPackagesConfigXmlParser
implements Serializable {
    private final Logger logger = LoggerFactory.getLogger(NugetPackagesConfigXmlParser.class);
    private File xml;
    private NugetConfigFileType nugetConfigFileType;

    public NugetPackagesConfigXmlParser(File xml, NugetConfigFileType nugetConfigFileType) {
        this.xml = xml;
        this.nugetConfigFileType = nugetConfigFileType;
    }

    public Set<DependencyInfo> parsePackagesConfigFile(boolean getDependenciesFromReferenceTag, String configFilePath) {
        Persister persister = new Persister();
        HashSet<DependencyInfo> dependencies = new HashSet<DependencyInfo>();
        try {
            if (this.nugetConfigFileType == NugetConfigFileType.CONFIG_FILE_TYPE) {
                NugetPackages packages = (NugetPackages)persister.read(NugetPackages.class, this.xml);
                if (!getDependenciesFromReferenceTag) {
                    dependencies.addAll(this.collectDependenciesFromNugetConfig(packages, configFilePath));
                }
            } else {
                NugetCsprojPackages csprojPackages = (NugetCsprojPackages)persister.read(NugetCsprojPackages.class, this.xml);
                NugetPackages packages = this.getNugetPackagesFromCsproj(csprojPackages);
                if (!getDependenciesFromReferenceTag) {
                    dependencies.addAll(this.collectDependenciesFromNugetConfig(packages, configFilePath));
                }
                dependencies.addAll(this.getDependenciesFromReferencesTag(csprojPackages));
            }
            dependencies.stream().forEach(dependencyInfo -> dependencyInfo.setSystemPath(this.xml.getPath()));
        }
        catch (Exception e) {
            this.logger.warn("Unable to parse suspected Nuget package configuration file {}", (Object)this.xml, (Object)e.getMessage());
        }
        return dependencies;
    }

    private NugetPackages getNugetPackagesFromCsproj(NugetCsprojPackages csprojPackages) {
        LinkedList<NugetPackage> nugetPackages = new LinkedList<NugetPackage>();
        for (NugetCsprojItemGroup csprojPackage : csprojPackages.getNugetItemGroups()) {
            for (PackageReference packageReference : csprojPackage.getPackageReference()) {
                if (packageReference == null || packageReference.getPkgName() == null || packageReference.getPkgVersion() == null) continue;
                nugetPackages.add(new NugetPackage(packageReference.getPkgName(), packageReference.getPkgVersion()));
            }
        }
        NugetPackages nugetPackagesResult = new NugetPackages();
        nugetPackagesResult.setNugetPackages(nugetPackages);
        return nugetPackagesResult;
    }

    private Set<DependencyInfo> getDependenciesFromReferencesTag(NugetCsprojPackages csprojPackages) {
        HashSet<DependencyInfo> dependencies = new HashSet<DependencyInfo>();
        DependencyInfoFactory dependencyInfoFactory = new DependencyInfoFactory();
        for (NugetCsprojItemGroup csprojPackage : csprojPackages.getNugetItemGroups()) {
            for (ReferenceTag referenceTag : csprojPackage.getReferences()) {
                Path basePath;
                Path hintParentResolvedPath;
                String hintAbsolutePath;
                File fileFromHintPath;
                DependencyInfo dependency;
                if (!StringUtils.isNotEmpty((String)referenceTag.getHintPath()) || (dependency = dependencyInfoFactory.createDependencyInfo((fileFromHintPath = new File(hintAbsolutePath = (hintParentResolvedPath = (basePath = FileSystems.getDefault().getPath(this.xml.getPath(), new String[0])).getParent().resolve(referenceTag.getHintPath())).normalize().toAbsolutePath().toString())).getParentFile(), fileFromHintPath.getName())) == null) continue;
                if (StringUtils.isNotEmpty((String)referenceTag.getVersion())) {
                    dependency.setVersion(referenceTag.getVersion());
                }
                dependencies.add(dependency);
            }
        }
        return dependencies;
    }

    private Set<DependencyInfo> collectDependenciesFromNugetConfig(NugetPackages configNugetPackage, String configFilePath) {
        HashSet<DependencyInfo> dependencies = new HashSet<DependencyInfo>();
        List<NugetPackage> nugetPackages = configNugetPackage.getNugetPackages();
        if (nugetPackages != null) {
            for (NugetPackage nugetPackage : nugetPackages) {
                if (!StringUtils.isNotBlank((String)nugetPackage.getPkgName()) || !StringUtils.isNotBlank((String)nugetPackage.getPkgVersion())) continue;
                DependencyInfo dependency = new DependencyInfo();
                dependency.setGroupId(nugetPackage.getPkgName());
                dependency.setArtifactId(nugetPackage.getPkgName());
                dependency.setVersion(nugetPackage.getPkgVersion());
                dependency.setDependencyType(DependencyType.NUGET);
                dependency.setSystemPath(configFilePath);
                dependencies.add(dependency);
            }
        }
        return dependencies;
    }
}

