/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.dependency.resolver.sbt;

import java.io.File;
import org.simpleframework.xml.core.Persister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whitesource.agent.dependency.resolver.BomFile;
import org.whitesource.agent.dependency.resolver.IBomParser;
import org.whitesource.agent.dependency.resolver.sbt.IvyReport;

public class SbtBomParser
implements IBomParser {
    private final Logger logger = LoggerFactory.getLogger(SbtBomParser.class);

    @Override
    public BomFile parseBomFile(String bomPath) {
        File bomFile = new File(bomPath);
        if (bomFile.isFile()) {
            Persister serializer = new Persister();
            try {
                IvyReport ivyReport = (IvyReport)serializer.read(IvyReport.class, bomFile);
                String groupId = ivyReport.getInfo().getGroupId();
                String artifactId = ivyReport.getInfo().getArtifactId();
                String version = ivyReport.getInfo().getVersion();
                return new BomFile(groupId, artifactId, version, bomPath);
            }
            catch (Exception e) {
                this.logger.warn("Couldn't parse {}, {}", (Object)bomPath, (Object)e.getMessage());
                this.logger.debug("stacktrace {}", (Object[])e.getStackTrace());
            }
        }
        return null;
    }
}

