/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.utils;

import com.sun.jna.Native;
import com.sun.jna.platform.win32.Kernel32;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whitesource.agent.dependency.resolver.DependencyCollector;

public class CommandLineProcess {
    private String rootDirectory;
    private String[] args;
    private long timeoutReadLineSeconds;
    private long timeoutProcessMinutes;
    private boolean errorInProcess = false;
    private Process processStart = null;
    private File errorLog = new File("error.log");
    private static final long DEFAULT_TIMEOUT_READLINE_SECONDS = 300L;
    private static final long DEFAULT_TIMEOUT_PROCESS_MINUTES = 15L;
    private static final String WINDOWS_SEPARATOR = "\\";
    private final Logger logger = LoggerFactory.getLogger(CommandLineProcess.class);

    public CommandLineProcess(String rootDirectory, String[] args) {
        this.rootDirectory = rootDirectory;
        this.args = args;
        this.timeoutReadLineSeconds = 300L;
        this.timeoutProcessMinutes = 15L;
    }

    public List<String> executeProcess() throws IOException {
        return this.executeProcess(true, false);
    }

    private List<String> executeProcess(boolean includeOutput, boolean includeErrorLines) throws IOException {
        String redirectErrorOutput;
        LinkedList<String> linesOutput = new LinkedList<String>();
        ProcessBuilder pb = new ProcessBuilder(this.args);
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Windows")) {
            this.rootDirectory = this.getShortPath(this.rootDirectory);
        }
        pb.directory(new File(this.rootDirectory));
        String string = redirectErrorOutput = DependencyCollector.isWindows() ? "nul" : "/dev/null";
        if (includeErrorLines) {
            pb.redirectError(this.errorLog);
        } else {
            pb.redirectError(new File(redirectErrorOutput));
        }
        if (!includeOutput || includeErrorLines) {
            pb.redirectOutput(new File(redirectErrorOutput));
        }
        if (!includeErrorLines) {
            this.logger.info("start execute command '{}' in '{}'", (Object)String.join((CharSequence)" ", this.args), (Object)this.rootDirectory);
        }
        this.processStart = pb.start();
        if (includeOutput) {
            ExecutorService executorService = Executors.newFixedThreadPool(1);
            InputStreamReader inputStreamReader = !includeErrorLines ? new InputStreamReader(this.processStart.getInputStream()) : new InputStreamReader(this.processStart.getErrorStream());
            BufferedReader reader = new BufferedReader(inputStreamReader);
            this.errorInProcess = this.readBlock(inputStreamReader, reader, executorService, linesOutput, includeErrorLines);
        }
        try {
            this.processStart.waitFor(this.timeoutProcessMinutes, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            this.errorInProcess = true;
            this.logger.error("'{}' was interrupted {}", (Object)this.args, (Object)e);
        }
        if (this.processStart.isAlive() && this.errorInProcess) {
            this.logger.debug("error executing command destroying process");
            this.processStart.destroy();
            return linesOutput;
        }
        if (this.getExitStatus() != 0) {
            this.logger.error("error in execute command {}", (Object)this.getExitStatus());
            this.errorInProcess = true;
        }
        this.printErrors();
        return linesOutput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printErrors() {
        if (this.errorLog.isFile()) {
            try {
                String currLine;
                FileReader fileReader = new FileReader(this.errorLog);
                BufferedReader bufferedReader = new BufferedReader(fileReader);
                while ((currLine = bufferedReader.readLine()) != null) {
                    this.logger.debug(currLine);
                }
                fileReader.close();
            }
            catch (Exception e) {
                this.logger.warn("Error printing cmd command errors {} ", (Object)e.getMessage());
                this.logger.error("Error: {}", (Object[])e.getStackTrace());
            }
            finally {
                try {
                    FileUtils.forceDelete((File)this.errorLog);
                }
                catch (IOException e) {
                    this.logger.warn("Error closing cmd command errors file {} ", (Object)e.getMessage());
                    this.logger.error("Error: {}", (Object[])e.getStackTrace());
                }
            }
        }
    }

    private String getShortPath(String rootPath) {
        File file = new File(rootPath);
        String lastPathAfterSeparator = null;
        String shortPath = this.getWindowsShortPath(file.getAbsolutePath());
        if (StringUtils.isNotEmpty((String)shortPath)) {
            return this.getWindowsShortPath(file.getAbsolutePath());
        }
        while (StringUtils.isEmpty((String)this.getWindowsShortPath(file.getAbsolutePath()))) {
            String filePath = file.getAbsolutePath();
            lastPathAfterSeparator = StringUtils.isNotEmpty(lastPathAfterSeparator) ? file.getAbsolutePath().substring(filePath.lastIndexOf(WINDOWS_SEPARATOR), filePath.length()) + lastPathAfterSeparator : file.getAbsolutePath().substring(filePath.lastIndexOf(WINDOWS_SEPARATOR), filePath.length());
            file = file.getParentFile();
        }
        return this.getWindowsShortPath(file.getAbsolutePath()) + lastPathAfterSeparator;
    }

    private String getWindowsShortPath(String path) {
        if (path.length() >= 256) {
            char[] result = new char[256];
            Kernel32.INSTANCE.GetShortPathName(path, result, result.length);
            return Native.toString((char[])result);
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readBlock(InputStreamReader inputStreamReader, BufferedReader reader, ExecutorService executorService, List<String> lines, boolean includeErrorLines) {
        boolean wasError = false;
        boolean continueReadingLines = true;
        try {
            if (!includeErrorLines) {
                this.logger.debug("trying to read lines using '{}'", (Object[])this.args);
            }
            int lineIndex = 1;
            String line = "";
            while (continueReadingLines && line != null) {
                Future<String> future = executorService.submit(new ReadLineTask(reader));
                try {
                    line = future.get(this.timeoutReadLineSeconds, TimeUnit.SECONDS);
                    if (!includeErrorLines) {
                        if (StringUtils.isNotBlank((String)line)) {
                            this.logger.debug("Read line #{}: {}", (Object)lineIndex, (Object)line);
                            lines.add(line);
                        } else {
                            this.logger.debug("Finished reading {} lines", (Object)(lineIndex - 1));
                        }
                    } else if (StringUtils.isNotBlank((String)line)) {
                        lines.add(line);
                    }
                }
                catch (TimeoutException e) {
                    this.logger.debug("Received timeout when reading line #" + lineIndex, (Object[])e.getStackTrace());
                    continueReadingLines = false;
                    wasError = true;
                }
                catch (Exception e) {
                    this.logger.debug("Error reading line #" + lineIndex, (Object[])e.getStackTrace());
                    continueReadingLines = false;
                    wasError = true;
                }
                ++lineIndex;
            }
        }
        catch (Exception e) {
            this.logger.error("error parsing output : {}", (Object[])e.getStackTrace());
        }
        finally {
            executorService.shutdown();
            IOUtils.closeQuietly((Closeable)inputStreamReader);
            IOUtils.closeQuietly((Closeable)reader);
        }
        return wasError;
    }

    public void executeProcessWithoutOutput() throws IOException {
        this.executeProcess(false, false);
    }

    public List<String> executeProcessWithErrorOutput() throws IOException {
        return this.executeProcess(false, true);
    }

    public void setTimeoutReadLineSeconds(long timeoutReadLineSeconds) {
        this.timeoutReadLineSeconds = timeoutReadLineSeconds;
    }

    public void setTimeoutProcessMinutes(long timeoutProcessMinutes) {
        this.timeoutProcessMinutes = timeoutProcessMinutes;
    }

    public boolean isErrorInProcess() {
        return this.errorInProcess;
    }

    public int getExitStatus() {
        if (this.processStart != null) {
            return this.processStart.exitValue();
        }
        return 0;
    }

    class ReadLineTask
    implements Callable<String> {
        private final BufferedReader reader;

        ReadLineTask(BufferedReader reader) {
            this.reader = reader;
        }

        @Override
        public String call() throws Exception {
            return this.reader.readLine();
        }
    }
}

