/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.fs;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whitesource.fs.FSAConfiguration;
import org.whitesource.fs.FileSystemAgent;
import org.whitesource.fs.ProjectsDetails;

public class ProjectsCalculator {
    private final Logger logger = LoggerFactory.getLogger(ProjectsCalculator.class);

    public ProjectsDetails getAllProjects(FSAConfiguration fsaConfiguration) {
        ArrayList<String> files = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)fsaConfiguration.getFileListPath())) {
            try {
                File listFile = new File(fsaConfiguration.getFileListPath());
                if (listFile.exists()) {
                    files.addAll(FileUtils.readLines((File)listFile));
                }
            }
            catch (IOException e) {
                this.logger.warn("Error reading list file");
            }
        }
        files.addAll(fsaConfiguration.getDependencyDirs());
        FileSystemAgent agent = new FileSystemAgent(fsaConfiguration, files);
        return agent.createProjects();
    }
}

