/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.fs.configuration;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.commons.io.IOUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whitesource.fs.configuration.ScmConfiguration;

public class ScmRepositoriesParser {
    private final Logger logger = LoggerFactory.getLogger(ScmRepositoriesParser.class);
    public static final String URL = "url";
    public static final String BRANCH = "branch";
    public static final String SCM_REPOSITORIES = "scmRepositories";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<ScmConfiguration> parseRepositoriesFile(String fileName, String scmType, String scmPpk, String scmUser, String scmPassword) {
        try (FileInputStream is = new FileInputStream(fileName);){
            String jsonText = IOUtils.toString((InputStream)is);
            JSONObject json = new JSONObject(jsonText);
            JSONArray arr = json.getJSONArray(SCM_REPOSITORIES);
            LinkedList<ScmConfiguration> configurationList = new LinkedList<ScmConfiguration>();
            arr.forEach(scm -> {
                JSONObject obj = (JSONObject)scm;
                String url = obj.getString(URL);
                String branch = obj.getString(BRANCH);
                String tag = obj.getString("tag");
                configurationList.add(new ScmConfiguration(scmType, scmUser, scmPassword, scmPpk, url, branch, tag, null, false, 1));
            });
            LinkedList<ScmConfiguration> linkedList = configurationList;
            return linkedList;
        }
        catch (FileNotFoundException e) {
            this.logger.error("file Not Found: {}", (Object)fileName);
            return null;
        }
        catch (IOException e) {
            this.logger.error("error getting file : {}", (Object)e.getMessage());
        }
        return null;
    }
}

